﻿namespace Events;

[System.Diagnostics.CodeAnalysis.SuppressMessage("Style", "IDE1006:Naming Styles", Justification = "This example illustrates roughly what code gets generated by the compiler, so the names do not conform to normal rules")]
public class RouglyHowEventsWork
{
    private Action<string>? Announcement;


    // To nie jest faktyczny kod.
    // Rzeczywisty kod jest bardziej złożony, by tolerować współbieżne wywołania
    public void add_Announcement(Action<string> handler)
    {
        Announcement += handler;
    }
    public void remove_Announcement(Action<string> handler)
    {
        Announcement -= handler;
    }

    public void Announce(string message) => this.Announcement?.Invoke(message);
}
