# Rozdział 8. - Przykłady

Przykłady z rozdziału 8. (Wyjątki) książki C# 10.0. Programowanie

## Źródła wyjątków

* [Listing 1. Wyjątek zgłaszany w wywołaniu składowej klasy należącej do biblioteki .NET](Wyjatki/Exceptions/Program.cs#L5-L14)
* [Listing 2. Potencjalny błąd wykrywany w trakcie działania programu](Wyjatki/Exceptions/Program.cs#L16-L19)

## Obsługa wyjątków

* [Listing 3. Obsługa wyjątków](Wyjatki/Exceptions/Program.cs#L23-L36)
* [Listing 4. Stosowanie wyjątku wewnątrz bloku catch](Wyjatki/Exceptions/Program.cs#L41-L55)
* [Listing 5. Obsługa wyjątków różnych typów](Wyjatki/Exceptions/Program.cs#L60-L81)
* [Listing 6. Blok catch z filtrem wyjątków](Wyjatki/Exceptions/Program.cs#L84-L96)
* [Listing 7. Zagnieżdżony kod obsługi wyjątków](Wyjatki/NestedExceptions/Program.cs#L5-L38)
* [Listing 8. Blok finally](Wyjatki/FinallyInterop/Program.cs#L5-L18)

## Zgłaszanie wyjątków

* [Listing 9. Zgłaszanie wyjątku](Wyjatki/Exceptions/Program.cs#L98-L106)
* [Listing 10. Zgłaszanie wyjątku ArgumentNullException](Wyjatki/Exceptions/Program.cs#L108-L112)
* [Listing 11. Jak nie należy powtórnie zgłaszać wyjątku](Wyjatki/Exceptions/Rethrow.cs#L7-L16)
* [Listing 12. Ponowne zgłaszanie wyjątku bez utraty kontekstu](Wyjatki/Exceptions/Rethrow.cs#L21-L29)

## Typy wyjąktów

* [Listing 13. Klasa niestandardowego wyjątku](Wyjatki/Exceptions/Custom/NotSerializable/DeviceNotReadyException.cs#L3-L32)
* [Listing 14. Dodawanie możliwości serializacji](Wyjatki/Exceptions/Custom/Serializable/DeviceNotReadyException.cs#L27-L39)
* [Listing 15. Powiadomienie o nieobsługiwanym wyjątku](Wyjatki/Unhandled/Program.cs#L5-L17)
