﻿static void CallDispose(IDisposable o)
{
    o.Dispose();
}

DisposableValue dv = new();
Console.WriteLine("Przekazujemy zmienną wartościową:");
CallDispose(dv);
CallDispose(dv);
CallDispose(dv);

IDisposable id = dv;
Console.WriteLine("Przekazujemy zmienną typu interfejsu:");
CallDispose(id);
CallDispose(id);
CallDispose(id);

Console.WriteLine("Wywołujemy metodę Dispose bezpośrednio na zmiennej typu wartościowego ");
dv.Dispose();
dv.Dispose();
dv.Dispose();

Console.WriteLine("Przekazujemy zmienną wartościową:");
CallDispose(dv);
CallDispose(dv);
CallDispose(dv);

public struct DisposableValue : IDisposable
{
    private bool _disposedYet;

    public void Dispose()
    {
        if (!_disposedYet)
        {
            Console.WriteLine("Zwalniamy po raz pierwszy.");
            _disposedYet = true;
        }
        else
        {
            Console.WriteLine("Obiekt już został zwolniony.");
        }
    }
}