﻿using GenericTypes;

void Show<T>(NamedContainer<T> c)
{
    Console.WriteLine($"{c.Name}: {c.Item}");
}

void ShowMany<T>(IEnumerable<NamedContainer<T>> cs)
{
    foreach (NamedContainer<T> c in cs)
    {
        Show(c);
    }
}

var a = new NamedContainer<int>(42, "Oto odpowiedź");
var b = new NamedContainer<int>(99, "Liczba czerwonych balonów");
var c = new NamedContainer<string>("Programowanie w C#", "Tytuł książki");


// ...gdzie a oraz b pochodzą z Listingu 4-3
var namedInts = new List<NamedContainer<int>>() { a, b };
var namedNamedItem = new NamedContainer<NamedContainer<int>>(a, "Opakowane");

Show(a);
Show(b);
Show(c);

ShowMany(namedInts);
Show(namedNamedItem);
