# Rozdział 2. - Przykłady

Przykłady z rozdziału 2. (Podstawy stosowania języka C#) książki C# 10.0. Programowanie

* [Listing 1. Kod i nic tylko kod](StarszeWersje/Short.cs)
* [Listing 2. Pełna postać kodu](StarszeWersje/Full.cs)

Zmienne lokalne

* [Listing 3. Deklaracje zmiennych](PodstawyStosowania/BasicCoding/Variables.cs#L7-L10)
* [Listing 4. Przypisywanie wartości zadeklarowanym wcześniej zmiennym](PodstawyStosowania/BasicCoding/Variables.cs#L12-L13)
* [Listing 5. Błąd: dane niewłaściwego typu](PodstawyStosowania/BasicCoding/Variables.cs#L19)
* [Listing 6. Niejawne typy danych i słowo kluczowe var](PodstawyStosowania/BasicCoding/Variables.cs#L30-L32)
* [Listing 7. Błąd: niewłaściwy typ danych (ponownie)](PodstawyStosowania/BasicCoding/Variables.cs#L44-L45)
* [Listing 8. Wiele zmiennych tworzonych przy użyciu jednej deklaracji](PodstawyStosowania/BasicCoding/Variables.cs#L22)
* [Listing 9. Stosowanie zmiennych](PodstawyStosowania/BasicCoding/Variables.cs#L116-L127)
* [Listing 10. Błąd: użycie niezainicjowanej zmiennej](PodstawyStosowania/BasicCoding/Variables.cs#L47-L48)
* [Listing 11. Błąd: poza zakresem](PodstawyStosowania/BasicCoding/Variables.cs#L51-L59)
* [Listing 12. Zmienna zadeklarowana poza blokiem i używana wewnątrz niego](PodstawyStosowania/BasicCoding/Variables.cs#L132-L136)
* [Listing 13. Błąd: próba użycia zmiennej poza jej zakresem](PodstawyStosowania/BasicCoding/Variables.cs#L63-L68)
* [Listing 14. Błąd: zaskakujący konflikt nazw](PodstawyStosowania/BasicCoding/Variables.cs#L73-L80)
* [Listing 15. Błąd: ukrywanie zmiennej](PodstawyStosowania/BasicCoding/Variables.cs#L90-L108)


Instrukcje i wyrażenia

* [Listing 16. Kilka instrukcji](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L7-L11)
* [Listing 17. Blok](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L16-L22)
* [Listing 18. Wyrażenia wewnątrz innych wyrażeń](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L27-L29)
* [Listing 19. Wyrażenia wywołania metod jako instrukcje](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L34-L37)
* [Listing 20. Błędy: przykłady wyrażeń, które nie mogą być instrukcjami](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L46-L47)
* [Listing 21. Przypisania jako wyrażenia](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L53-L60)
* [Listing 22. Kolejność przetwarzania operandów](PodstawyStosowania/OperandEvaluationOrder/Program.cs)
* [Listing 23. Kolejność przetwarzania operandów w przypadku wyrażeń zagnieżdżonych](PodstawyStosowania/OperandEvaluationOrderNested/Program.cs#L7-L10)

Komentarze i białe znaki
 
 * [Listing 24. Komentarze jednowierszowe](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L7-L8)
 * [Listing 25. Komentarze oddzielone](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L13-L19)
 * [Listing 26. Komentarze wielowierszowe](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L21-L25)
 * [Listing 27. Białe znaki bez znaczenia](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L30-L34)

Dyrektywy preprocesora:

* [Listing 28. Kompilacja warunkowa](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L7-L13)
* [Listing 29. Metoda warunkowa](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L16-L20)
* [Listing 30. Generowanie błędu kompilatora](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L24-L26)
* [Listing 31. Dyrektywa #line i celowy błąd](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L34-L35)
* [Listing 32. Wyłączanie ostrzeżeń kompilatora](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L38-L39)

Podstawowe typy danych

* [Listing 33. Niejawne konwersje liczb](PodstawyStosowania/BasicCoding/Conversions.cs#L7-L11)
* [Listing 34. Błąd: niedostępna konwersja niejawna](PodstawyStosowania/BasicCoding/Conversions.cs#L20-L22)
* [Listing 35. Jawna konwersja przy użyciu rzutowania](PodstawyStosowania/BasicCoding/Conversions.cs#L28-L30)
* [Listing 36. Wykorzystanie niesprawdzanego przepełnienia danych typu całkowitego](PodstawyStosowania/BasicCoding/Conversions.cs#L37-L42)
* [Listing 37. Wyrażenie sprawdzane](PodstawyStosowania/BasicCoding/Conversions.cs#L51)
* [Listing 38. Instrukcja sprawdzana](PodstawyStosowania/BasicCoding/Conversions.cs#L53-L57)
* [Listing 39. Zastosowanie typu BigInteger](PodstawyStosowania/UsingBigInteger/Program.cs)
* [Listing 40. Znaki a dane typu char](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L13-L14)
* [Listing 41. Wyrażenia w łańcuchach znaków](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L21)
* [Listing 42. Umieszczanie w łańcuchach bardziej złożonych wyrażeń](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L23-L24)
* [Listing 43. Wynik interpolacji łańcucha znaków](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L34-L37)
* [Listing 44. Interpolowany łańcuch znaków, który potencjalnie może nie zostać użyty](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L63)
* [Listing 45. Specyfikator formatu](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L45)
* [Listing 46. Specyfikatory formatu użyte z niezmiennikiem kulturowym](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L52-L56)
* [Listing 47. Tworzenie i stosowanie krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L7-L8)
* [Listing 48. Określanie nazw elementów krotek w inicjalizatorze](PodstawyStosowania/BasicCoding/Tuples.cs#L13-L14)
* [Listing 49. Wnioskowanie nazw elementów krotki na podstawie użytych zmiennych](PodstawyStosowania/BasicCoding/Tuples.cs#L19-L21)
* [Listing 50. Domyślne nazwy elementów krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L26-L27)
* [Listing 51. Strukturalna równoważność krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L32-L34)
* [Listing 52. Tworzenie i dekonstrukcja krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L42-L48)
* [Listing 53. Zastosowanie w dekonstrukcji kroki deklarowania nowej oraz użycia już istniejącej zmiennej](PodstawyStosowania/BasicCoding/Tuples.cs#L50-L51)
* [Listing 54. Dekonstrukcja krotki z pominięciem](PodstawyStosowania/BasicCoding/Tuples.cs#L55)

Operatory

* [Listing 55. Warunkowy operator AND](PodstawyStosowania/BasicCoding/Operators.cs#L7)
* [Listing 56. Operator trójargumentowy](PodstawyStosowania/BasicCoding/Operators.cs#L15)
* [Listing 57. Zastosowanie przetwarzania warunkowego](PodstawyStosowania/BasicCoding/Operators.cs#L22)
* [Listing 58. Operator null coalescing](PodstawyStosowania/BasicCoding/Operators.cs#L29)
* [Listing 59. Użycie operatora warunkowego wartości pustych oraz operatora null coalescing](PodstawyStosowania/BasicCoding/Operators.cs#L36)
* [Listing 60. Wyrażenie warunkowe jako argument wywołania metody](PodstawyStosowania/BasicCoding/Operators.cs#L46)
* [Listing 61. Życie bez operatora warunkowego](PodstawyStosowania/BasicCoding/Operators.cs#L54-L63)
* [Listing 62. Przypisanie i dodawanie](PodstawyStosowania/BasicCoding/Operators.cs#L73)
* [Listing 63. Złożone przypisanie (dodawanie)](PodstawyStosowania/BasicCoding/Operators.cs#L77)

Sterowanie przepływem

* [Listing 64. Prosta instrukcja if](PodstawyStosowania/BasicCoding/FlowControl.cs#L7-L10)
* [Listing 65. Zapewne nie o to nam chodziło](PodstawyStosowania/BasicCoding/FlowControl.cs#L19-L21)
* [Listing 66. If oraz else](PodstawyStosowania/BasicCoding/FlowControl.cs#L26-L34)
* [Listing 67. Wybór jednej spośród kilku możliwości](PodstawyStosowania/BasicCoding/FlowControl.cs#L38-L49)
* [Listing 68. Zbyt wiele bloków](PodstawyStosowania/BasicCoding/FlowControl.cs#L54-L68)
* [Listing 69. Instrukcja switch operująca na łańcuchach znaków](PodstawyStosowania/BasicCoding/FlowControl.cs#L73-L97)
* [Listing 70. Przechodzenie stosowane w kodzie C, niedozwolone w C#](PodstawyStosowania/BasicCoding/FlowControl.cs#L106-L113)
* [Listing 71. Przechodzenie do kolejnej sekcji case w C#](PodstawyStosowania/BasicCoding/FlowControl.cs#L119-L127)
* [Listing 72. Pętla while](PodstawyStosowania/BasicCoding/FlowControl.cs#L132-L135)
* [Listing 73. Pętla do](PodstawyStosowania/BasicCoding/FlowControl.cs#L140-L146)
* [Listing 74. Modyfikacja elementów tablicy przy użyciu pętli for](PodstawyStosowania/BasicCoding/FlowControl.cs#L151-L154)
* [Listing 75. Kilka inicjalizatorów oraz iteratorów](PodstawyStosowania/BasicCoding/FlowControl.cs#L156)
* [Listing 76. Zagnieżdżone pętle for](PodstawyStosowania/BasicCoding/FlowControl.cs#L167-L173)
* [Listing 77. Przeglądanie kolekcji przy użyciu pętli foreach](PodstawyStosowania/BasicCoding/FlowControl.cs#L178-L182)
* [Listing 78. Ogólny sposób przetwarzania kolekcji](PodstawyStosowania/BasicCoding/FlowControl.cs#L187-L193)

Wzorce

* [Listing 79. Wzorce deklaracji](PodstawyStosowania/BasicCoding/Patterns.cs#L7-L16)
* [Listing 80. Wzorce typu](PodstawyStosowania/BasicCoding/Patterns.cs#L21-L30)
* [Listing 81. Wzorzec pozycyjny](PodstawyStosowania/BasicCoding/Patterns.cs#L41-L43)
* [Listing 82. Wzorce pozycyjne z wartościami stałymi](PodstawyStosowania/BasicCoding/Patterns.cs#L57-L71)
* [Listing 83. Wzorzec pozycyjny składający się ze wzorca stałej i wzorca deklaracji](PodstawyStosowania/BasicCoding/Patterns.cs#L37-L39)
* [Listing 84. Wzorzec pozycyjny ze słowem kluczowym var](PodstawyStosowania/BasicCoding/Patterns.cs#L49-L51)
* [Listing 85. Wzorzec pozycyjny ze wzorcem pominięcia](PodstawyStosowania/BasicCoding/Patterns.cs#L45-L47)
* [Listing 86. Wzorzec właściwości](PodstawyStosowania/BasicCoding/Patterns.cs#L78-L80)
* [Listing 87. Wzorzec właściwości zwracający wynik](PodstawyStosowania/BasicCoding/Patterns.cs#L85-L87)
* [Listing 88. Wzorzec właściwości z zagnieżdżonym wzorcem zwracającym wynik](PodstawyStosowania/BasicCoding/Patterns.cs#L92-L94)
* [Listing 89. Wzorzec właściwości z zagnieżdżonym innym wzorcem właściwości](PodstawyStosowania/BasicCoding/Patterns.cs#L97-L102)
* [Listing 90. Rozszerzony wzorzec właściwości](PodstawyStosowania/BasicCoding/Patterns.cs#L106-L108)
* [Listing 91. Wykrywanie wartości niepustych z użyciem negacji wzorca](PodstawyStosowania/BasicCoding/Patterns.cs#L116-L118)
* [Listing 92. Zastosowanie łączenia (and) oraz negacji (not) wzorców](PodstawyStosowania/BasicCoding/Patterns.cs#L123-L125)
* [Listing 93. Wzorce relacyjne](PodstawyStosowania/BasicCoding/Patterns.cs#L131-L136)
* [Listing 94. Zastosowanie połączenia wzorców relacyjnych](PodstawyStosowania/BasicCoding/Patterns.cs#L140-L142)
* [Listing 95. Wzorzec z klauzulą when](PodstawyStosowania/BasicCoding/Patterns.cs#L150-152)
* [Listing 96. Wzorce, lecz nie w wyrażeniach](PodstawyStosowania/BasicCoding/Patterns.cs#L158-L164)
* [Listing 97. Wyrażenie switch](PodstawyStosowania/BasicCoding/Patterns.cs#L169-L175)
* [Listing 98. Wyrażenie is](PodstawyStosowania/BasicCoding/Patterns.cs#L180)
* [Listing 99. Sprawdzanie wartości pustych z użyciem is](PodstawyStosowania/BasicCoding/Patterns.cs#L198-L201)
* [Listing 100. Użycie wartości pobranych ze wzorca wyrażenia is](PodstawyStosowania/BasicCoding/Patterns.cs#L185-L188)
* [Listing 101. We wzorcach w wyrażeniu is nie trzeba stosować klauzuli when](PodstawyStosowania/BasicCoding/Patterns.cs#L190-L193)
