# Rozdział 6. - Przykłady

Przykłady z rozdziału 6. (Dziedziczenie) książki C# 10.0. Programowanie

* [Listing 1. Określanie klasy bazowej](Dziedziczenie/Bases/SpecifyingBase.cs#L7-L14)
* [Listing 2. Łańcuch dziedziczenia](Dziedziczenie/Bases/InheritanceChain.cs#L3-L13)

## Dziedziczenie i konwersje

* [Listing 3. Przykład rzutowania w dół](Dziedziczenie/Bases/Conversions.cs#L5-L10)
* [Listing 4. Zastosowanie operatora as](Dziedziczenie/Bases/Conversions.cs#L12-L20)
* [Listing 5. Operator is i wzorzec deklaracji](Dziedziczenie/Bases/TypePattern.cs#L5-L11)

## Dziedziczenie interfejsów

* [Listing 6. Dziedziczenie interfejsów](Dziedziczenie/Bases/InterfaceInheritance.cs#L3-L16)
* [Listing 7. Implementacja interfejsu pochodnego](Dziedziczenie/Bases/Impl.cs#L3-L16)

## Typy ogólne

* [Listing 8. Dziedziczenie po ogólnej klasie bazowej](Dziedziczenie/Generics/Program.cs#L12-L35)
* [Listing 9. Argument typu, odwołujący się do danego typu](Dziedziczenie/Generics/Program.cs#L37-L45)
* [Listing 10. Metoda pobierająca dowolny argument typu Base](Dziedziczenie/Generics/Base.cs#L5-L7)
* [Listing 11. Metoda pobierająca argument typu IEnumerable<Base>](Dziedziczenie/Generics/Base.cs#L9-L11)
* [Listing 12. Przekazanie interfejsu IEnumerable<T> typu pochodnego](Dziedziczenie/Generics/Base.cs#L15-L16)
* [Listing 13. Metoda pobierająca argument dowolnego typu ICollection<Base>](Dziedziczenie/Generics/Base.cs#L19-L22)
* [Listing 14. Błąd: próba przekazania interfejsu ICollection<T> typu pochodnego](Dziedziczenie/Generics/Base.cs#L28-L29)
* [Listing 15. Kowariantny parametr typu](Dziedziczenie/Generics/Program.cs#L50)
* [Listing 16. Hierarchia klas definiujących składowe](Dziedziczenie/Generics/ClassHierarchy.cs#L3-L11)
* [Listing 17. Porównywanie kształtów](Dziedziczenie/Generics/ClassHierarchy.cs#L13-L50)
* [Listing 18. Kontrawariantny parametr typu](Dziedziczenie/Generics/Program.cs#L52)
* [Listing 19. Zmiana elementu tablicy](Dziedziczenie/Generics/Base.cs#L34-L37)
* [Listing 20. Przekazywanie tablicy o elementach typu pochodnego](Dziedziczenie/Generics/Base.cs#L40-L41)

## Metody wirtualne

* [Listing 21. Klasa z metodą wirtualną](Dziedziczenie/Virtuals/BaseWithVirtual.cs#L3-L9)
* [Listing 22. Stosowanie metod wirtualnych](Dziedziczenie/Virtuals/Program.cs#L16-L19)
* [Listing 23. Przesłanianie metod wirtualnych](Dziedziczenie/Virtuals/DeriveWithAndWithoutOverride.cs#L3-L13)
* [Listing 24. Wykorzystanie metod wirtualnych](Dziedziczenie/Virtuals/Program.cs#L23-L25)
* [Listing 25. Metoda przesłaniająca, która zawęża typ wyniku](Dziedziczenie/Virtuals/CovariantReturnType/ChangeReturnTypeInOverride.cs#L3-L14)
* [Listing 26. Klasa abstrakcyjna](Dziedziczenie/Virtuals/AbstractBase.cs#L3-L6)
* [Listing 27. Abstrakcyjna implementacja interfejsu](Dziedziczenie/Virtuals/MustBeComparable.cs#L3-L6)
* [Listing 28. Typ bazowy w wersji 1.0](Dziedziczenie/Library1.0/LibraryBase.cs#L3-L5)
* [Listing 29. Klasa pochodna dla biblioteki w wersji 1.0](Dziedziczenie/Virtuals/CustomerDerived.cs#L8-L14)
* [Listing 30. Typ bazowy w wersji 1.1](Dziedziczenie/Library1.1/LibraryBase.cs#L3-L6)
* [Listing 31. Metody ukryte a wirtualne](Dziedziczenie/Virtuals/Program.cs#L9-L13)
* [Listing 32. Unikanie ostrzeżeń podczas ukrywania składowych](Dziedziczenie/Virtuals/CustomerDerived.cs#L17-L23)
* [Listing 33. Ukrywanie w celu zmiany sygnatury](Dziedziczenie/Virtuals/Program.cs#L32-L36)

## Metody i klasy ostateczne

* [Listing 34. Metoda ostateczna](Dziedziczenie/Virtuals/FixedToString.cs#L3-L9)
* [Listing 35. Klasa ostateczna](Dziedziczenie/Virtuals/EndOfTheLine.cs#L3-L5)

## Dostęp do składowych klas bazowych

* [Listing 36. Wywołanie przesłoniętej metody klasy bazowej](Dziedziczenie/Virtuals/CallBase/CustomerDerived.cs#L5-L12)

## Dziedziczenie i tworzenie obiektów

* [Listing 37. Brak domyślnego konstruktora w klasie pochodnej](Dziedziczenie/Construction/Example37/Code.cs#L3-L17)
* [Listing 38. Jawne wywoływanie konstruktora klasy bazowej](Dziedziczenie/Construction/Example38/Code.cs#L3-L24)
* [Listing 39. Określanie kolejności tworzenia obiektów](Dziedziczenie/Construction/Program.cs#L23-L51)

## Rekordy

* [Listing 40. Dziedziczenie typów rekordów](Dziedziczenie/Records/Labelled.cs#L3-L10)
* [Listing 41. Tworzenie obiektów pochodnych typów rekordów](Dziedziczenie/Records/Program.cs#L3-L13)
* [Listing 42. Dziedziczenie po typie rekordu zdefiniowanym z użyciem składni pozycyjnej](Dziedziczenie/Records/Positional.cs#L3-L5)
* [Listing 43. Przekazywanie wartości stałej do rekordu bazowego używającego składni pozy-cyjnej](Dziedziczenie/Records/Positional.cs#L7)
* [Listing 44. Stosowanie rekordów pochodnych, w których wymagana właściwość typu bazo-wego jest opcjonalna](Dziedziczenie/Records/Program.cs#L20-L21)
* [Listing 45. Przekazywanie argumentów do rekordu bazowego korzystającego ze składni pozy-cyjnej, z użyciem zwyczajnego konstruktora](Dziedziczenie/Records/Positional.cs#L9-L13)
* [Listing 46. Przekształcenie opcjonalnej właściwości typu bazowego na właściwość pozycyjną](Dziedziczenie/Records/Positional.cs#L15-L21)
* [Listing 47. Stosowanie with z bazowym typem rekordu](Dziedziczenie/Records/Program.cs#L26-L32)
* [Listing 48. Testowanie użycia słowa kluczowego with z dziedziczeniem](Dziedziczenie/Records/Program.cs#L34-L35)
