﻿namespace Records.Positional;

internal static class UsingPositionalRecords
{
    public static void Use()
    {
        void ShowPerson(Person p)
        {
            Console.WriteLine($"{p.Name}'s favorite color is {p.FavoriteColor}");
        }

        var ian = new Person("Jan", "niebieski");
        var deborah = new Person("Debora", "zielony");
        ShowPerson(ian);
        ShowPerson(deborah);

        var startingRecord = new Person("Jan", "niebieski");
        var modified = startingRecord with
        {
            FavoriteColor = "zielony"
        };

        Console.WriteLine(modified);

        var p1 = new Person("Jan", "niebieski");
        var p2 = new Person("Jan", "niebieski");
        if (p1 == p2)
        {
            Console.WriteLine("równe");
        }
    }
}
