# Rozdział 17. - Przykłady

Przykłady z rozdziału 17. (Asynchroniczne cechy języka) książki C# 10.0. Programowanie

## Nowe słowa kluczowe: async oraz await

* [Listing 1. Stosowanie słów kluczowych async i await podczas pobierania nagłówków HTTP](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L39-L50)
* [Listing 2. Wywoływanie metody asynchronicznej](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L33-L37)
* [Listing 3. Samodzielne tworzenie odpowiednika metody asynchronicznej](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L52-L72)
* [Listing 4. Stosowanie metody ConfigureAwait](Asynchronicznosc/AsyncAwait/ConfigureAwaitWindow.xaml.cs#L25-L36)
* [Listing 5. Wykonywanie wielu operacji asynchronicznych](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L34-L50)
* [Listing 6. Niekompletna samodzielna implementacja pętli asynchronicznej](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L52-L84)
* [Listing 7. Metoda IEnumerator.MoveNext, która nie wspiera operacji asynchronicznych](Asynchronicznosc/AsyncSequences/Program.cs#L23)
* [Listing 8. IAsyncEnumerable&lt;T&gt; oraz IAsyncEnumerator&lt;T&gt;](Asynchronicznosc/AsyncSequences/Program.cs#L26-L37)
* [Listing 9. Tworzenie i stosowanie asynchronicznego typu wyliczalnego](Asynchronicznosc/AsyncSequences/Program.cs#L1-L16)
* [Listing 10. Stosowanie i implementacja interfejsu IAsyncDisposable](Asynchronicznosc/AsyncDispose/Program.cs)
* [Listing 11. Zwracanie zadania](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L32)
* [Listing 12. Zwracanie zadania Task&lt;T&gt;](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L86-L103)
* [Listing 13. Asynchroniczne wyrażenie lambda](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L24-L30)

## Wzorzec słowa kluczowego await

* [Listing 14. Wywoływanie niestandardowej implementacji typu współpracującego z await](Asynchronicznosc/AwaitPattern/Program.cs#L10-L19)
* [Listing 15. Wyjątkowo prosta implementacja wzorca słowa kluczowego await](Asynchronicznosc/AwaitPattern/MyAwaitableType.cs#L5-L23)
* [Listing 16. Bardzo ogólne przybliżenie działania słowa kluczowego await](Asynchronicznosc/AwaitPattern/Program.cs#L24-L41)
* [Listing 17. Nieco lepsze przybliżenie sposobu działania słowa kluczowego await](Asynchronicznosc/AwaitPattern/Program.cs#L44-L70)

## Obsługa błędów

* [Listing 18. Kilka potencjalnych źródeł niepowodzenia](Asynchronicznosc/ErrorHandling/Program.cs#L21-L41)
* [Listing 19. Obsługa wyjątków zgłaszanych w wyrażeniu await](Asynchronicznosc/ErrorHandling/Program.cs#L45-L54)
* [Listing 20. W jaki sposób nie należy sprawdzać poprawności argumentów](Asynchronicznosc/ErrorHandling/Program.cs#L59-L61)
* [Listing 21. Weryfikacja argumentów metody asynchronicznej](Asynchronicznosc/ErrorHandling/Program.cs#L70-L79)
* [Listing 22. Zastosowanie słowa kluczowego await i metody Wait](Asynchronicznosc/ErrorHandling/Program.cs#L82-L96)
* [Listing 23. Poszukiwanie dodatkowych wyjątków](Asynchronicznosc/ErrorHandling/Program.cs#L100-L118)
* [Listing 24. W jaki sposób nie należy wykonywać wielu współbieżnych operacji](Asynchronicznosc/ErrorHandling/Program.cs#L121-L134)
