﻿namespace Streams;

class Program
{
    static void Main()
    {
    }

    static int ReadAll(Stream s, byte[] buffer, int offset, int length)
    {
        if ((offset + length) > buffer.Length)
        {
            throw new ArgumentException("Bufor jest zbyt mały, by pomieścić żądane dane.");
        }

        int bytesReadSoFar = 0;
        while (bytesReadSoFar < length)
        {
            int bytes = s.Read(
                buffer, offset + bytesReadSoFar, length - bytesReadSoFar);
            if (bytes == 0)
            {
                break;
            }
            bytesReadSoFar += bytes;
        }

        return bytesReadSoFar;
    }
}

// Składowe klasy Stream zamieszczone tylko w celach demonstracyjnych. Klasa ta jest
// zdefiniowana w .NET, więc nie musimy jej definować samodzielnie.
#if false
public abstract int Read(byte[] buffer, int offset, int count);
public abstract void Write(byte[] buffer, int offset, int count);
public abstract long Position { get; set; }

public abstract long Seek(long offset, SeekOrigin origin);
#endif
