﻿using System.Runtime.CompilerServices;

namespace Attributes;

public static class CallerInfo
{
    public static void Log(
        string message,
        [CallerMemberName] string callingMethod = "",
        [CallerFilePath] string callingFile = "",
        [CallerLineNumber] int callingLineNumber = 0)
    {
        Console.WriteLine("Komunikat {0}, wywołanie z {1} w pliku '{2}', numer wiersza {3}",
            message, callingMethod, callingFile, callingLineNumber);
    }
}