﻿using System.Diagnostics;

namespace AnonymousFunctions;

public static class AnonymousMethodSyntax
{
    public static int GetIndexOfFirstNonEmptyBin(int[] bins)
    {
        return Array.FindIndex(
            bins,
            delegate (int value) { return value > 0; }
        );
    }

    public static void IgnoringArguments()
    {
        EventHandler clickHandler = delegate { Debug.WriteLine("Kliknięto przycisk!"); };

        clickHandler(new object(), EventArgs.Empty);
    }

    public static void DiscardingArguments()
    {
        EventHandler clickHandler = (_, _) => Debug.WriteLine("Klinięto przycisk!");

        clickHandler(new object(), EventArgs.Empty);
    }
}
