﻿namespace Dictionaries;

public class UserCache
{
    private readonly Dictionary<string, UserInfo> _cachedUserInfo = new();

    public UserInfo GetInfo(string userHandle)
    {
        RemoveStaleCacheEntries();
        if (!_cachedUserInfo.TryGetValue(userHandle, out UserInfo? info))
        {
            info = FetchUserInfo(userHandle);
            _cachedUserInfo.Add(userHandle, info);
        }
        return info;
    }

    private UserInfo FetchUserInfo(string userHandle)
    {
        // pobieramy informacje ...
        return new UserInfo();
    }

    private void RemoveStaleCacheEntries()
    {
        // logika aplikacji określająca kiedy należy usuwać stare elementy...
    }
}

public class UserInfo
{
    // informacje o użytkowniku (zależne od aplikacji )...
}
