﻿using static System.Console;

WriteLine($"Otrzymano {args.Length} argumentów.");

foreach (string arg in args)
{
  WriteLine(arg);
}

if (args.Length < 3)
{
  WriteLine("Musisz podać dwa kolory oraz wymiary okna, np.:");
  WriteLine("dotnet run red yellow 80 40");
  return; // Zakończ pracę.
}

ForegroundColor = (ConsoleColor)Enum.Parse(
  enumType: typeof(ConsoleColor),
  value: args[0],
  ignoreCase: true);

BackgroundColor = (ConsoleColor)Enum.Parse(
  enumType: typeof(ConsoleColor),
  value: args[1],
  ignoreCase: true);

try
{
  CursorSize = int.Parse(args[2]);
}
catch (PlatformNotSupportedException)
{
  WriteLine("Aktualna platforma nie pozwala na zmianę wielkości kursora.");
}

if (OperatingSystem.IsWindows())
{
  // wykonaj kod działający wyłącznie w systemie Windows
}
else if (OperatingSystem.IsWindowsVersionAtLeast(major: 10))
{
  // wykonaj kod działający wyłącznie w systemie Windows 10 lub nowszym
}
else if (OperatingSystem.IsIOSVersionAtLeast(major: 14, minor: 5))
{
  // wykonaj kod działający wyłącznie w systemie iOS 14.5 lub nowszym
}
else if (OperatingSystem.IsBrowser())
{
  // wykonaj kod działający wyłącznie w przeglądarce z technologią Blazor
}

#if NET6_0_ANDROID
// kompiluj instrukcje działające w systemie Android
#elif NET6_0_IOS
// kompiluj instrukcje działające w systemie iOS
#else
// kompiluj instrukcje działające w pozostałych systemach
#endif
