﻿using System.Diagnostics;
using Microsoft.Extensions.Configuration;

// write to a text file in the project folder
Trace.Listeners.Add(new TextWriterTraceListener(
  File.CreateText(Path.Combine(Environment.GetFolderPath(
    Environment.SpecialFolder.DesktopDirectory), "log.txt"))));

// Zapisywanie tekstu jest buforowane, a ta opcja wywołuje
// metodę Flush() we wszystkich obiektach nasłuchujących
// po wykonaniu każdego zapisu.
Trace.AutoFlush = true;

Debug.WriteLine("Typ Debug mówi, że już jest gotowy!");
Trace.WriteLine("Typ Trace mówi, że już jest gotowy!");

ConfigurationBuilder tworcaKonfiguracji = new();

tworcaKonfiguracji.SetBasePath(Directory.GetCurrentDirectory())
  .AddJsonFile("appsettings.json",
    optional: true, reloadOnChange: true);

IConfigurationRoot konfiguracja = tworcaKonfiguracji.Build();

TraceSwitch ts = new(
  displayName: "Przelacznik",
  description: "Ten przełącznik jest ustawiany przez konfigurację z pliku JSON.");

konfiguracja.GetSection("Przelacznik").Bind(ts);

Trace.WriteLineIf(ts.TraceError, "Poziom błędów");
Trace.WriteLineIf(ts.TraceWarning, "Poziom ostrzeżeń");
Trace.WriteLineIf(ts.TraceInfo, "Poziom informacji");
Trace.WriteLineIf(ts.TraceVerbose, "Poziom ogólny");
