using Microsoft.AspNetCore.Mvc.RazorPages; // PageModel
using BibliotekaWspolna; // NorthwindContext
using Microsoft.AspNetCore.Mvc; // [BindProperty], IActionResult

namespace Northwind.Web.Pages;

public class DostawcyModel : PageModel
{
  public IEnumerable<Supplier>? Dostawcy { get; set; }

  private NorthwindContext db;

  public DostawcyModel(NorthwindContext wstrzyknietyKontekst)
  {
    db = wstrzyknietyKontekst;
  }

  public void OnGet()
  {
    ViewData["Tytul"] = "Witryna WWW firmy Northwind - Dostawcy";

    Dostawcy = db.Suppliers
      .OrderBy(c => c.Country).ThenBy(c => c.CompanyName);
  }

  [BindProperty]
  public Supplier? Dostawca { get; set; }

  public IActionResult OnPost()
  {
    if ((Dostawca is not null) && ModelState.IsValid)
    {
      db.Suppliers.Add(Dostawca);
      db.SaveChanges();
      return RedirectToPage("/dostawcy");
    }
    else
    {
      return Page(); // powrót do pierwotnej strony
    }
  }
}
