﻿using Microsoft.AspNetCore.Mvc.RazorPages; // PageModel
using BibliotekaWspolna; // Employee, NorthwindContext

namespace FunkcjeDlaCS10.Pages;

public class ModelStronyPracownikow : PageModel
{
  private NorthwindContext db;

  public ModelStronyPracownikow(NorthwindContext wstrzyknietyKontekst)
  {
    db = wstrzyknietyKontekst;
  }

  public Employee[] Pracownicy { get; set; } = null!;

  public void OnGet()
  {
    ViewData["Tytul"] = "Witryna WWW firmy Northwind - Pracownicy";
    Pracownicy = db.Employees.OrderBy(e => e.LastName)
      .ThenBy(e => e.FirstName).ToArray();
  }
}
