﻿using Microsoft.AspNetCore.Identity; // RoleManager, UserManager
using Microsoft.AspNetCore.Mvc; // Controller, IActionResult

using static System.Console;

namespace Northwind.Mvc.Controllers;

public class RolesController : Controller
{
  private string RolaAdmina = "Administratorzy";
  private string AdresUzytkownika = "test@przyklad.pl";

  private readonly RoleManager<IdentityRole> managerRol;
  private readonly UserManager<IdentityUser> managerUzytkownikow;

  public RolesController(RoleManager<IdentityRole> managerRol,
    UserManager<IdentityUser> managerUzytkownikow)
  {
    this.managerRol = managerRol;
    this.managerUzytkownikow = managerUzytkownikow;
  }

  public async Task<IActionResult> Index()
  {
    if (!(await managerRol.RoleExistsAsync(RolaAdmina)))
    {
      await managerRol.CreateAsync(new IdentityRole(RolaAdmina));
    }

    IdentityUser uzytkownik = await managerUzytkownikow.FindByEmailAsync(AdresUzytkownika);

    if (uzytkownik == null)
    {
      uzytkownik = new();
      uzytkownik.UserName = AdresUzytkownika;
      uzytkownik.Email = AdresUzytkownika;
      IdentityResult wynik = await managerUzytkownikow.CreateAsync(
        uzytkownik, "Ha$$l0");

      if (wynik.Succeeded)
      {
        WriteLine($"Użytkownik {uzytkownik.UserName} został utworzony.");
      }
      else
      {
        foreach (IdentityError blad in wynik.Errors)
        {
          WriteLine(blad.Description);
        }
      }
    }

    if (!uzytkownik.EmailConfirmed)
    {
      string token = await managerUzytkownikow.GenerateEmailConfirmationTokenAsync(uzytkownik);
      IdentityResult wynik = await managerUzytkownikow.ConfirmEmailAsync(uzytkownik, token);

      if (wynik.Succeeded)
      {
        WriteLine($"Adres e-mail użytkownika {uzytkownik.UserName} został potwierdzony.");
      }
      else
      {
        foreach (IdentityError blad in wynik.Errors)
        {
          WriteLine(blad.Description);
        }
      }
    }

    if (!(await managerUzytkownikow.IsInRoleAsync(uzytkownik, RolaAdmina)))
    {
      IdentityResult wynik = await managerUzytkownikow
        .AddToRoleAsync(uzytkownik, RolaAdmina);

      if (wynik.Succeeded)
      {
        WriteLine($"Użytkownik {uzytkownik.UserName} został dodany do roli {RolaAdmina}.");
      }
      else
      {
        foreach (IdentityError blad in wynik.Errors)
        {
          WriteLine(blad.Description);
        }
      }
    }

    return Redirect("/");
  }
}
