﻿using Microsoft.AspNetCore.Mvc; // [ApiController], [Route]
using Microsoft.EntityFrameworkCore; // ToListAsync, FirstOrDefaultAsync
using BibliotekaWspolna; // NorthwindContext, Customer

namespace Northwind.BlazorWasm.Server.Controllers;

[ApiController]
[Route("api/[controller]")]
public class KlienciController : ControllerBase
{
  private readonly NorthwindContext db;

  public KlienciController(NorthwindContext db)
  {
    this.db = db;
  }

  [HttpGet]
  public async Task<List<Customer>> PobierzKlientowAsync()
  {
    return await db.Customers.ToListAsync();
  }

  [HttpGet("in/{kraj}")] // inna ścieża, aby uniknąć pomyłek
  public async Task<List<Customer>> PobierzKlientowAsync(string kraj)
  {
    return await db.Customers
      .Where(k => k.Country == kraj).ToListAsync();
  }

  [HttpGet("{id}")]
  public async Task<Customer?> PobierzKlientaAsync(string id)
  {
    return await db.Customers
      .FirstOrDefaultAsync(k => k.CustomerId == id);
  }

  [HttpPost]
  public async Task<Customer?> UtworzKlientaAsync
    (Customer klientDoDodania)
  {
    Customer? istniejacy = await db.Customers.FirstOrDefaultAsync
      (k => k.CustomerId == klientDoDodania.CustomerId);

    if (istniejacy == null)
    {
      db.Customers.Add(klientDoDodania);
      int zmienione = await db.SaveChangesAsync();
      if (zmienione == 1)
      {
        return klientDoDodania;
      }
    }
    return istniejacy;
  }

  [HttpPut]
  public async Task<Customer?> AktualizujKlientaAsync(Customer k)
  {
    db.Entry(k).State = EntityState.Modified;
    int zmienione = await db.SaveChangesAsync();
    if (zmienione == 1)
    {
      return k;
    }
    return null;
  }

  [HttpDelete("{id}")]
  public async Task<int> UsunKlientaAsync(string id)
  {
    Customer? k = await db.Customers.FirstOrDefaultAsync
      (k => k.CustomerId == id);

    if (k != null)
    {
      db.Customers.Remove(k);
      int zmienione = await db.SaveChangesAsync();
      return zmienione;
    }
    return 0;
  }
}
