﻿using System.Diagnostics;  // Stopwatch

using static System.Console;
using static System.Diagnostics.Process;  // GetCurrentProcess()

namespace BibliotekaWspolna;

public static class Nagrywanie
{
   private static Stopwatch stoper = new();

   private static long fizyczneBajtyPrzed = 0;
   private static long wirtualneBajtyPrzed = 0;

   public static void Start()
   {
      // Wymuszamy dwa cykle oczyszczania pamięci, aby zwolnić
      // nieużywaną już pamięć, która jeszcze nie została zwolniona.
      GC.Collect();
      GC.WaitForPendingFinalizers();
      GC.Collect();

      // Zapisujemy poziom wykorzystania pamięci fizycznej i wirtualnej.
      fizyczneBajtyPrzed = GetCurrentProcess().WorkingSet64;
      wirtualneBajtyPrzed = GetCurrentProcess().VirtualMemorySize64;
      stoper.Restart();
   }

   public static void Stop()
   {
      stoper.Stop();
      long fizyczneBajtyPo = GetCurrentProcess().WorkingSet64;
      long wirtualneBajtyPo = GetCurrentProcess().VirtualMemorySize64;

      WriteLine($"Wykorzystano {0:N0} fizycznych bajtów.",
        fizyczneBajtyPo - fizyczneBajtyPrzed);

      WriteLine($"Wykorzystano {0:N0} wirtualnych bajtów.",
        wirtualneBajtyPo - wirtualneBajtyPrzed);

      WriteLine($"Upłynęło {0} czasu.", stoper.Elapsed);

      WriteLine($"Upłynęło {0:N0} milisekund.",
        stoper.ElapsedMilliseconds);
   }
}
