﻿using System.Text; // Encoding

using static System.Console;

WriteLine("Kodowania");
WriteLine("[1] ASCII");
WriteLine("[2] UTF-7");
WriteLine("[3] UTF-8");
WriteLine("[4] UTF-16 (Unicode)");
WriteLine("[5] UTF-32");
WriteLine("[inny klawisz] Domyślne");

// wybieranie kodowania
Write("Naciśnij cyfrę, żeby wybrać kodowanie: ");
ConsoleKey klawisz = ReadKey(false).Key;
WriteLine();
WriteLine();

Encoding enkoder = klawisz switch
{
   ConsoleKey.D1 => Encoding.ASCII,
   ConsoleKey.D2 => Encoding.UTF7,
   ConsoleKey.D3 => Encoding.UTF8,
   ConsoleKey.D4 => Encoding.Unicode,
   ConsoleKey.D5 => Encoding.UTF32,
   _ => Encoding.Default
};

// definiowanie ciągu znaków do zakodowania
string komunikat = "Litr mleka kosztuje 1,99 zł";

// kodowanie ciągu znaków do tablicy bajtów
byte[] zakodowane = enkoder.GetBytes(komunikat);

// sprawdzenie, ile bajtów wymagało to kodowanie
WriteLine($"Kodowanie {0} zajęło {1} bajtów.",
  enkoder.GetType().Name, zakodowane.Length);
WriteLine();

// przejrzenie wszystkich bajtów
WriteLine($"Bajt  Hex  Znak");
foreach (byte b in zakodowane)
{
   WriteLine($"{b,4} {b.ToString("X"),4} {(char)b,5}");
}

// dekodowanie tablicy bajtów do postaci ciągu znaków i wyświetlenie go
string odkodowane = enkoder.GetString(zakodowane);
WriteLine(odkodowane);
