﻿using System.Globalization; // CultureInfo

using static System.Console;

CultureInfo globalizacja = CultureInfo.CurrentCulture;
CultureInfo lokalizacja = CultureInfo.CurrentUICulture;

WriteLine($"Aktualna kultura globalizacji to {0}: {1}",
  globalizacja.Name, globalizacja.DisplayName);

WriteLine($"Aktualna kultura lokalizacji to {0}: {1}",
  lokalizacja.Name, lokalizacja.DisplayName);

WriteLine();

WriteLine("en-US: Angielski (USA)");
WriteLine("pl-PL: Polski (Polska)");
WriteLine("fr-CA: Francuski (Kanada)");

Write("Podaj kod ISO kultury: ");
String? nowaKultura = ReadLine();

if (!string.IsNullOrEmpty(nowaKultura))
{
   CultureInfo ci = new(nowaKultura);

   // zmieniamy obie kultury
   CultureInfo.CurrentCulture = ci;
   CultureInfo.CurrentUICulture = ci;
}
WriteLine();

Write("Jak się nazywasz: ");
string? nazwisko = ReadLine();

Write("Podaj datę urodzenia: ");
string? dataUrodzenia = ReadLine();

Write("Podaj, ile zarabiasz: ");
string? pensja = ReadLine();

DateTime data = DateTime.Parse(dataUrodzenia);
int minuty = (int)DateTime.Today.Subtract(data).TotalMinutes;
decimal zarabia = decimal.Parse(pensja);

WriteLine("{0}, data urodzenia: {1:dddd} na świecie jest od {2:N0} minut i zarabia {3:C}.",
  nazwisko, data, minuty, zarabia);

