﻿using Microsoft.EntityFrameworkCore; // UseSqlite
using Microsoft.Extensions.DependencyInjection; // IServiceCollection

namespace BibliotekaWspolna;

public static class NorthwindContextExtensions
{
   /// <summary>
   /// Dodaje obiekt NorthwindContext do wskazanej kolekcji typu
   /// IServiceCollection. Używa dostawcy bazy danych Sqlite.
   /// </summary>
   /// <param name="serwisy"></param>
   /// <param name="sciezkaWzgledna">Ta wartość podmienia domyślną ścieżkę ".."</param>
   /// <returns>Kolekcja typu IServiceCollection,
   /// której można użyć do dodawania kolejnych serwisów.</returns>
   public static IServiceCollection DodajKontekstNorthwind(
    this IServiceCollection serwisy, string sciezkaWzgledna = "..")
  {
    string sciezkaBazyDanych = Path.Combine(sciezkaWzgledna, "Northwind.db");

    serwisy.AddDbContext<NorthwindContext>(options =>
      options.UseSqlite($"Data Source={sciezkaBazyDanych}")
      .UseLoggerFactory(new ConsoleLoggerFactory())
    );

    return serwisy;
  }
}
