﻿using System.Text.Json; // JsonSerializer
using System.Text.Json.Serialization; // [JsonInclude]
using PracaZJson;

using static System.Console;
using static System.Environment;
using static System.IO.Path;

Ksiazka csharp10 = new(tytul:
  "C# 10 and .NET 6 – Modern Cross-Platform Development ")
{
   Autor = "Mark J Price",
   DataPublikacji = new(year: 2021, month: 11, day: 9),
   LiczbaStron = 823,
   Utworzone = DateTimeOffset.UtcNow,
};

JsonSerializerOptions opcje = new()
{
   IncludeFields = true, // Dołącza wszystkie pola
   PropertyNameCaseInsensitive = true,
   WriteIndented = true,
   PropertyNamingPolicy = JsonNamingPolicy.CamelCase,
};

string sciezkaPliku = Combine(CurrentDirectory, "ksiazka.json");

using (Stream strumienPliku = File.Create(sciezkaPliku))
{
   JsonSerializer.Serialize<Ksiazka>(
     utf8Json: strumienPliku, value: csharp10, opcje);
}

WriteLine("Do pliku {0} zapisano {1:N0} bajtow",
  arg0: sciezkaPliku,
  arg1: new FileInfo(sciezkaPliku).Length);

WriteLine();

// Wyświetlenie zserializowanego grafu obiektów
WriteLine(File.ReadAllText(sciezkaPliku));


public class Ksiazka
{
   // konstruktor definiujący wartość nienullowalnej właściwości
   public Ksiazka(string tytul)
   {
      Tytul = tytul;
   }
   // właściwości
   public string Tytul { get; set; }
   public string? Autor { get; set; }

   // pola
   [JsonInclude] // dołączaj to pole
   public DateOnly DataPublikacji;

   [JsonInclude] // dołączaj to pole
   public DateTimeOffset Utworzone;

   public ushort LiczbaStron;
}
