using Microsoft.AspNetCore.Identity; // IdentityUser
using Microsoft.EntityFrameworkCore; // UseSqlServer, UseSqlite
using Northwind.Mvc.Data; // ApplicationDbContext
using BibliotekaWspolna; // Metoda rozszerzająca DodajKontekstNorthwind
using System.Net.Http.Headers; // MediaTypeWithQualityHeaderValue
using Northwind.Mvc.Hubs; // ChatHub

var builder = WebApplication.CreateBuilder(args);

// Dodawanie serwisów do kontenera

builder.Services.AddHttpClient(name: "Northwind.WebApi",
  configureClient: opcje =>
  {
    opcje.BaseAddress = new Uri("https://localhost:5002/");
    opcje.DefaultRequestHeaders.Accept.Add(
      new MediaTypeWithQualityHeaderValue(
      "application/json", 1.0));
  });

builder.Services.AddHttpClient(name: "Minimalne.WebApi",
  configureClient: opcje =>
  {
    opcje.BaseAddress = new Uri("https://localhost:5003/");
    opcje.DefaultRequestHeaders.Accept.Add(
      new MediaTypeWithQualityHeaderValue(
      "application/json", 1.0));
  });

builder.Services.AddHttpClient(name: "Northwind.OData",
  configureClient: opcje =>
  {
    opcje.BaseAddress = new Uri("https://localhost:5004/");
    opcje.DefaultRequestHeaders.Accept.Add(
      new MediaTypeWithQualityHeaderValue(
      "application/json", 1.0));
  });

builder.Services.AddHttpClient(name: "Northwind.GraphQL",
configureClient: opcje =>
{
  opcje.BaseAddress = new Uri("https://localhost:5005/");
  opcje.DefaultRequestHeaders.Accept.Add(
    new MediaTypeWithQualityHeaderValue(
    "application/json", 1.0));
});

builder.Services.AddSignalR();

var connectionString = builder.Configuration.GetConnectionString("DefaultConnection");

builder.Services.AddDbContext<ApplicationDbContext>(opcje =>
    opcje.UseSqlServer(connectionString));

builder.Services.AddDatabaseDeveloperPageExceptionFilter();

builder.Services.AddDefaultIdentity<IdentityUser>(opcje => 
  opcje.SignIn.RequireConfirmedAccount = true)
  .AddRoles<IdentityRole>() // włącza zarządzania rolami
  .AddEntityFrameworkStores<ApplicationDbContext>();

builder.Services.AddControllersWithViews();

// jeżeli używasz serwera SQL Server
string polaczenieZSqlServer = builder.Configuration
  .GetConnectionString("NorthwindConnection");
//builder.Services.AddNorthwindContext(sqlServerConnection);

// jeżeli używasz bazy SQLite, to domyślną ścieżką jest ..\Northwind.db
builder.Services.DodajKontekstNorthwind();

var app = builder.Build();

// Konfigurowanie potoku obsługi żądań HTTP.
if (app.Environment.IsDevelopment())
{
  app.UseMigrationsEndPoint();
}
else
{
  app.UseExceptionHandler("/Home/Error");
   // Domyślną wartością dla HSTS jest 30 dni. Na serwerach produkcyjnych lepiej jest zmienić tę wartość. Zobacz też https://aka.ms/aspnetcore-hsts
   app.UseHsts();
}

app.UseHttpsRedirection();
app.UseStaticFiles();

app.UseRouting();

app.UseAuthentication();
app.UseAuthorization();

app.MapControllerRoute(
    name: "default",
    pattern: "{controller=Home}/{action=Index}/{id?}");

app.MapRazorPages();

app.MapHub<ChatHub>("/chat");

app.Run();
