using System.ComponentModel.DataAnnotations.Schema; // [Column]

namespace BibliotekaWspolna;

public class Category
{
  // te właściwości odwzorowują kolumny w bazie danych
  public int CategoryId { get; set; }
  public string? CategoryName { get; set; }

  [Column(TypeName = "ntext")]
  public string? Description { get; set; }

  // definiuje właściwość nawigacyjną dla powiązanych wierszy
  public virtual ICollection<Product> Products { get; set; }

  public Category()
  {
    // aby umożliwiść dodawanie produktów do kategorii 
    // musimy zainicjować tę właściwość pustą kolekcją
    Products = new HashSet<Product>();
  }
}
