﻿using Microsoft.CodeAnalysis;
namespace SourceGenerator;
[Generator]
public class HelloSourceGenerator : ISourceGenerator
{
    public void Execute(GeneratorExecutionContext context)
    {
        // Generowany kod źródłowy.
        string source = """
namespace BlazorWebAssemblyApp;
public class GeneratedService
    {
        public string GetHello()
        {
            return "To jest wygenerowany kod źródłowy";
        }
    }
""";
        // Włączenie kodu źródłowego w proces kompilacji
        context.AddSource($"GeneratedService.g.cs", source);
}

    public void Initialize(GeneratorInitializationContext context)
    {
        // Nie jest wymagana inicjalizacja
    }
}

