# -*- coding: utf-8 -*-
import sys
import socket
import threading



# jest to elegancka funkcja do robienia zrzutw szesnastkowych wydobyta wprost z 
# komentarzy na tej stronie:
# http://code.activestate.com/recipes/142812-hex-dumper/def hexdump(src, length=16):
    result = []
    digits = 4 if isinstance(src, unicode) else 2

    for i in xrange(0, len(src), length):
       s = src[i:i+length]
       hexa = b' '.join(["%0*X" % (digits, ord(x))  for x in s])
       text = b''.join([x if 0x20 <= ord(x) < 0x7F else b'.'  for x in s])
       result.append( b"%04X   %-*s   %s" % (i, length*(digits + 1), hexa, text) )

    print b'\n'.join(result)


def receive_from(connection):
        
        buffer = ""

	# ustawiamy 2-sekundowy limit czasu; w niektrych przypadkach
	# moe by konieczna zmiana tej wartoci
	connection.settimeout(2)
	
        try:
                # wczytujemy dane do bufora, a wczytamy wszystkie
		# albo skoczy si nam czas
                while True:
                        data = connection.recv(4096)
                        
                        if not data:
                                break
                        
                        buffer += data
                
                
        except:
		pass
        
        return buffer

# modyfikujemy dania przeznaczone dla zdalnego hosta
def request_handler(buffer):
	# modyfikujemy pakiety
	return buffer

# modyfikujemy odpowiedzi przeznaczone dla lokalnego hosta
def response_handler(buffer):
	# modyfikujemy pakiety
	return buffer


def proxy_handler(client_socket, remote_host, remote_port, receive_first):
        
        # czymy si ze zdalnym hostem
        remote_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        remote_socket.connect((remote_host,remote_port))

        # odebranie danych od zdalnego hosta w razie potrzeby
        if receive_first:
                
                remote_buffer = receive_from(remote_socket)
                hexdump(remote_buffer)
		
                # wysanie danych do procedury obsugi odpowiedzi
		remote_buffer = response_handler(remote_buffer)
                
                # jeli mamy dane do wysania do klienta lokalnego, to je wysyamy
                if len(remote_buffer):
                        print "[<==] Wysyanie %d bajtw do localhost." % len(remote_buffer)
                        client_socket.send(remote_buffer)
                        
	# uruchamiamy ptl, w ktrej odczytujemy dane z hosta lokalnego, wysyamy dane do hosta zdalnego, wysyamy dane do hosta lokalnego
	# wszystko powtarzamy
	while True:
		
		# odczyt z lokalnego hosta
		local_buffer = receive_from(client_socket)


		if len(local_buffer):	
			
			print "[==>] Odebrano %d bajtw od localhost." % len(local_buffer)
			hexdump(local_buffer)
			
			# wysanie danych do procedury obsugi da
			local_buffer = request_handler(local_buffer)
			
			# wysanie danych do zdalnego hosta
			remote_socket.send(local_buffer)
			print "[==>] Wysano do zdalnego hosta."
		
		
		# odebranie odpowiedzi
		remote_buffer = receive_from(remote_socket)

		if len(remote_buffer):
			
			print "[<==] Odebrano %d bajtw od zdalnego hosta." % len(remote_buffer)
			hexdump(remote_buffer)
			
			# wysanie danych do procedury obsugi odpowiedzi
			remote_buffer = response_handler(remote_buffer)
		
			# wysanie odpowiedzi do lokalnego gniazda
			client_socket.send(remote_buffer)
			
			print "[<==] Wysano do localhost."
		
		# jeli nie ma wicej danych po adnej ze stron, zamykamy poczenia
		if not len(local_buffer) or not len(remote_buffer):
			client_socket.close()
			remote_socket.close()
			print "[*] Nie ma wicej danych. Zamykanie pocze."
		
			break
		
def server_loop(local_host,local_port,remote_host,remote_port,receive_first):
                
        server = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

        try:
                server.bind((local_host,local_port))
        except:
                print "[!!] Nieudana prba nasuchu na porcie  %s:%d" % (local_host,local_port)
                print "[!!] Poszukaj innego gniazda lub zdobd odpowiednie uprawnienia."
                sys.exit(0)
                
        print "[*] Nasuchiwanie na %s:%d" % (local_host,local_port)
        
        
        server.listen(5)        
        
        while True:
                client_socket, addr = server.accept()
               
                # wydruk informacji o poczeniu lokalnym
                print "[==>] Otrzymano poczenie przychodzce od %s:%d" % (addr[0],addr[1])
                
                # uruchomienie wtku do wsppracy ze zdalnym hostem
                proxy_thread = threading.Thread(target=proxy_handler,args=(client_socket,remote_host,remote_port,receive_first))
                proxy_thread.start()

def main():
        
    # adnego dziwnego przetwarzania wiersza polece
    if len(sys.argv[1:]) != 5:
        print "Sposb uycia: ./proxy.py [localhost] [localport] [remotehost] [remoteport] [receive_first]"
        print "Przykad: ./proxy.py 127.0.0.1 9000 10.12.132.1 9000 True"
        sys.exit(0)
    
    # konfiguracja lokalnych parametrw nasuchu
    local_host  = sys.argv[1]
    local_port  = int(sys.argv[2])
    
    # ustawienie zdalnego celu
    remote_host = sys.argv[3]
    remote_port = int(sys.argv[4])
    
    # nakazujemy proxy nawizanie poczenia i odebranie danych
    # przed wysaniem danych do zdalnego hosta
    receive_first = sys.argv[5]
    
    if "True" in receive_first:
	    receive_first = True
    else:
	    receive_first = False
	    
    
    # wczamy gniazdo do nasuchu
    server_loop(local_host,local_port,remote_host,remote_port,receive_first)
        
main() 
