/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.Cut;
import org.python.google.common.collect.Range;

@GwtIncompatible(value="NavigableMap")
final class RangeMap<K extends Comparable, V>
implements Function<K, V>,
Serializable {
    private final NavigableMap<Cut<K>, RangeValue<K, V>> map;
    private static final long serialVersionUID = 0L;

    public static <K extends Comparable, V> RangeMap<K, V> create() {
        return new RangeMap<K, V>(new TreeMap<Cut<K>, RangeValue<K, V>>());
    }

    private RangeMap(NavigableMap<Cut<K>, RangeValue<K, V>> map) {
        this.map = map;
    }

    @Override
    public V apply(K input) {
        return this.get(input);
    }

    @Nullable
    public V get(K key) {
        Map.Entry<Cut<K>, RangeValue<K, V>> lowerEntry = this.map.lowerEntry(Cut.aboveValue(key));
        if (lowerEntry != null && ((Range)lowerEntry.getValue().getKey()).contains(key)) {
            return lowerEntry.getValue().getValue();
        }
        return null;
    }

    public void put(Range<K> keyRange, V value) {
        Preconditions.checkNotNull(keyRange);
        Preconditions.checkNotNull(value);
        if (keyRange.isEmpty()) {
            return;
        }
        this.clear(keyRange);
        this.putRange(new RangeValue<K, V>(keyRange, value));
    }

    public void putAll(RangeMap<K, V> rangeMap) {
        Preconditions.checkNotNull(rangeMap);
        for (RangeValue rangeValue : rangeMap.map.values()) {
            this.put((Range)rangeValue.getKey(), rangeValue.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public void clear(Range<K> rangeToClear) {
        RangeValue lowerRangeValue;
        Cut<K> upperCut;
        Map.Entry lowerThanUB;
        RangeValue lowerRangeValue2;
        Cut<K> upperCut2;
        Preconditions.checkNotNull(rangeToClear);
        if (rangeToClear.isEmpty()) {
            return;
        }
        Map.Entry lowerThanLB = this.map.lowerEntry(rangeToClear.lowerBound);
        if (lowerThanLB != null && (upperCut2 = (lowerRangeValue2 = lowerThanLB.getValue()).getUpperBound()).compareTo(rangeToClear.lowerBound) >= 0) {
            RangeValue<K, V> replacement = lowerRangeValue2.withUpperBound(rangeToClear.lowerBound);
            if (replacement == null) {
                this.removeRange(lowerRangeValue2);
            } else {
                this.putRange(replacement);
            }
            if (upperCut2.compareTo(rangeToClear.upperBound) >= 0) {
                this.putRange(lowerRangeValue2.withLowerBound(rangeToClear.upperBound));
                return;
            }
        }
        if ((lowerThanUB = this.map.lowerEntry(rangeToClear.upperBound)) != null && (upperCut = (lowerRangeValue = lowerThanUB.getValue()).getUpperBound()).compareTo(rangeToClear.upperBound) >= 0) {
            this.removeRange(lowerRangeValue);
            this.putRange(lowerRangeValue.withLowerBound(rangeToClear.upperBound));
        }
        this.map.subMap(rangeToClear.lowerBound, rangeToClear.upperBound).clear();
    }

    private void removeRange(RangeValue<K, V> rangeValue) {
        RangeValue removed = (RangeValue)this.map.remove(rangeValue.getLowerBound());
        assert (removed == rangeValue);
    }

    private void putRange(@Nullable RangeValue<K, V> rangeValue) {
        if (rangeValue != null && !((Range)rangeValue.getKey()).isEmpty()) {
            this.map.put(rangeValue.getLowerBound(), rangeValue);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o instanceof RangeMap && this.map.equals(((RangeMap)o).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    private static final class RangeValue<K extends Comparable, V>
    extends AbstractMap.SimpleEntry<Range<K>, V> {
        private static final long serialVersionUID = 0L;

        RangeValue(Range<K> key, V value) {
            super(Preconditions.checkNotNull(key), Preconditions.checkNotNull(value));
            assert (!key.isEmpty());
        }

        Cut<K> getLowerBound() {
            return ((Range)this.getKey()).lowerBound;
        }

        Cut<K> getUpperBound() {
            return ((Range)this.getKey()).upperBound;
        }

        @Nullable
        RangeValue<K, V> withLowerBound(Cut<K> newLowerBound) {
            Range<K> newRange = new Range<K>(newLowerBound, this.getUpperBound());
            return newRange.isEmpty() ? null : new RangeValue(newRange, this.getValue());
        }

        @Nullable
        RangeValue<K, V> withUpperBound(Cut<K> newUpperBound) {
            Range<K> newRange = new Range<K>(this.getLowerBound(), newUpperBound);
            return newRange.isEmpty() ? null : new RangeValue(newRange, this.getValue());
        }
    }
}

