/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.NativeMethods;
import com.kenai.jffi.PageManager;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.ffi.Platform;
import jnr.ffi.provider.jffi.MemoryUtil;
import jnr.ffi.provider.jffi.StubCompiler;
import jnr.ffi.provider.jffi.X86Disassembler;
import jnr.x86asm.Assembler;

abstract class AbstractX86StubCompiler
extends StubCompiler {
    public static final boolean DEBUG = Boolean.getBoolean("jnr.ffi.compile.dump");
    final List<Stub> stubs = new LinkedList<Stub>();

    AbstractX86StubCompiler() {
    }

    /*
     * WARNING - void declaration
     */
    void attach(Class clazz) {
        void methods;
        void fn;
        long l;
        if (this.stubs.isEmpty()) {
            return;
        }
        long codeSize = 0L;
        for (Stub stub : this.stubs) {
            codeSize += (long)(stub.assembler.codeSize() + 8);
        }
        PageManager pm = PageManager.getInstance();
        long l2 = pm.allocatePages((int)(l = (codeSize + pm.pageSize() - 1L) / pm.pageSize()), 3);
        if (l2 == 0L) {
            throw new OutOfMemoryError("allocatePages failed for codeSize=" + codeSize);
        }
        PageHolder pageHolder = new PageHolder(pm, l2, l);
        ArrayList arrayList = new ArrayList(this.stubs.size());
        long l3 = l2;
        PrintStream printStream = System.err;
        System.out.flush();
        System.err.flush();
        for (Stub stub : this.stubs) {
            void buf;
            void asm;
            Assembler assembler = stub.assembler;
            l3 = AbstractX86StubCompiler.align(l3, 8L);
            ByteBuffer byteBuffer = ByteBuffer.allocate(assembler.codeSize()).order(ByteOrder.LITTLE_ENDIAN);
            asm.assembler.relocCode(byteBuffer, l3);
            byteBuffer.flip();
            MemoryIO.getInstance().putByteArray(l3, byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
            if (DEBUG && X86Disassembler.isAvailable()) {
                void disassembler;
                void i$;
                i$.println(clazz.getName() + "." + asm.name + " " + asm.signature);
                X86Disassembler x86Disassembler = X86Disassembler.create();
                x86Disassembler.setMode(Platform.getNativePlatform().getCPU() == Platform.CPU.I386 ? X86Disassembler.Mode.I386 : X86Disassembler.Mode.X86_64);
                x86Disassembler.setSyntax(X86Disassembler.Syntax.INTEL);
                x86Disassembler.setInputBuffer(MemoryUtil.newPointer(l3), buf.offset());
                while (x86Disassembler.disassemble()) {
                    i$.printf("%8x: %s\n", x86Disassembler.offset(), x86Disassembler.insn());
                }
                if (disassembler.remaining() > buf.offset()) {
                    i$.printf("%8x: <indirect call trampolines>\n", buf.offset());
                }
                i$.println();
            }
            fn.add(new NativeMethod(l3, asm.name, asm.signature));
            l3 += (long)buf.codeSize();
        }
        pm.protectPages(l2, (int)l, 5);
        NativeMethods.register(clazz, (List<NativeMethod>)fn);
        StaticDataHolder.PAGES.put(clazz, (PageHolder)methods);
    }

    static final int align(int offset, int align) {
        return offset + align - 1 & ~(align - 1);
    }

    static final long align(long offset, long align) {
        return offset + align - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static final class PageHolder {
        final PageManager pm;
        final long memory;
        final long pageCount;

        public PageHolder(PageManager pm, long memory, long pageCount) {
            this.pm = pm;
            this.memory = memory;
            this.pageCount = pageCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pm.freePages(this.memory, (int)this.pageCount);
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when freeing native pages: %s", t.getLocalizedMessage());
            }
            finally {
                super.finalize();
            }
        }
    }

    static final class Stub {
        final String name;
        final String signature;
        final Assembler assembler;

        public Stub(String name, String signature, Assembler assembler) {
            this.name = name;
            this.signature = signature;
            this.assembler = assembler;
        }
    }

    private static final class StaticDataHolder {
        static final Map<Class, PageHolder> PAGES = Collections.synchronizedMap(new WeakHashMap());

        private StaticDataHolder() {
        }
    }
}

