(function($) {
	$.fn.mutationObserver = function(action) {
		return this.each(function(i, element) {
			var $element = $(element);
			var instance = $element.data('plugin_mutationObserver');

			if (action === 'destroy' && instance) {
				instance.observer.disconnect();
				instance.observer = null;
				$element.removeData('plugin_mutationObserver');
				return;
			}

			if (!instance) {
				var observer = new MutationObserver(function(mutations) {
					mutations.forEach(function(mutation) {
						instance.callbacks.forEach(function(callbackFn) {
							callbackFn(mutation);
						});
					});
				});

				observer.observe(element, {
					attributes: true,
					childList: true,
					characterData: true
				});

				instance = {
					observer: observer,
					callbacks: []
				};
				$element.data('plugin_mutationObserver', instance);
			}

			if (typeof action === 'function') {
				instance.callbacks.push(action);
			}
		});
	};
})(jQuery);
