$.fn.mutationObserver = function(action) {
	var instance = this.data('plugin_mutationObserver');

	if (action === 'destroy' && instance) {
		instance.observer.disconnect();
		this.removeData('plugin_mutationObserver');
		return this;
	}

	if (!instance) {
		var observer = new MutationObserver(function(mutations) {
			mutations.forEach(function(mutation) {
				instance.callbacks.forEach(function(callbackFn) {
					callbackFn(mutation);
				});
			});
		});

		observer.observe(this[0], {
			attributes: true,
			childList: true,
			characterData: true
		});

		instance = {
			observer: observer,
			callbacks: []
		};
		this.data('plugin_mutationObserver', instance);
	}

	if (typeof action === 'function') {
		instance.callbacks.push(action);
	}

	return this;
};
