var d = $.Deferred();
setTimeout(function() {
    d.resolve(7);
}, 2000);
var p = d.promise();

var d = $.Deferred(function (deferred) {
    setTimeout(function() {
        deferred.resolve(7);
    }, 2000);
});
var p = d.promise();

// lub 
var p = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(7);
    }, 2000);
});

p.then(function(result) { // takie samo działanie w bibliotce jQuery i języku ECMAScript 6
    console.log(result);
}, function(error) {
    console.error('Wystąpił błąd: ', error);
});



//****************************
var p = $.Deferred(function (deferred) {
    deferred.reject(new Error('Coś się stało!'));
}).promise();

p.then(null, function(x) {
    console.error(x);
});

// lub
var p = new Promise(function(resolve, reject) {
    reject(new Error('Coś się stało!'));
});
p.then(null, function(x) {
    console.error(x);
});



//****************************
var p = $.Deferred().resolve(7).promise();
p.then(function(x) {
    console.log(x);
});

// lub
var p = Promise.resolve(7);
p.then(function(x) {
    console.log(x);
});



//****************************
var p = $.Deferred().reject(new Error('Coś się stało!')).promise();
p.fail(function(error) {
    console.error(error);
});

// lub
var p = Promise.reject(new Error('Coś się stało!'));
p.catch(function(error) {
    console.error(error);
});



//**************************************
//********* TWORZENIE ŁAŃCUCHA *********
//**************************************
var p = $.Deferred().resolve(7).promise();
p.then(null, function (error) {
    console.error('Wystąpił błąd!'); // brak uruchomienia z powodu ustalenia dla obiektu Promise stanu Rozstrzygnięty
}).then(function(x) {
    console.log(x); // rejestruje liczbę 7
});

// lub
var p = Promise.resolve(7);
p.then(null, function (error) {
    console.error('Wystąpił błąd!'); // brak uruchomienia z powodu ustalenia dla obiektu Promise stanu Rozstrzygnięty
}).then(function(x) {
    console.log(x); // rejestruje liczbę  7
});


//****************************
var p = $.Deferred().resolve(7).promise();
p.then(function(x) {
    console.log(x); // rejestruje liczbę  7
    return x * 3;
}).then(function(x) {
    console.log(x); // rejestruje liczbę  21
});

// lub
var p = Promise.resolve(7);
p.then(function(x) {
    console.log(x); // rejestruje liczbę  7
    return x * 3;
}).then(function(x) {
    console.log(x); // rejestruje liczbę 21
});

//****************************
var p = $.Deferred().resolve(7).promise();
p.then(function(x) {
    console.log(x); // rejestruje liczbę 7
}).then(function(x) {
    console.log(x); // rejestruje undefined
});

// lub
var p = Promise.resolve(7);
p.then(function(x) {
    console.log(x); // rejestruje liczbę 7
}).then(function(x) {
    console.log(x); // rejestruje undefined
});




//****************************
var d = $.Deferred();
setTimeout(function() {
    d.resolve(7);
}, 2000);
var p = d.promise();

p.then(function(x) {
    console.log(x); // rejestruje liczbę 7
    var d2 = $.Deferred();
    setTimeout(function() {
        d2.resolve(x*3);
    }, 2000);
    return d2.promise();
}).then(function(x) {
    console.log(x); // rejestruje liczbę 21
});

// lub
var p = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(7);
    }, 2000);
});
p.then(function(x) {
    console.log(x); // rejestruje liczbę 7
    return new Promise(function(resolve) {
        setTimeout(function() {
            resolve(x*3);
        }, 2000);
    });
}).then(function(x) {
    console.log(x); // rejestruje liczbę 21
});




//****************************
//******* KOMPOZYCJA ********
//****************************
var p1 = $.Deferred(function (d1) {
    setTimeout(function() {
        d1.resolve(7);
    }, 2000);
}).promise();

var p2 = $.Deferred(function (d2) {
    setTimeout(function() {
        d2.resolve(11);
    }, 3000);
}).promise();

$.when(p1, p2).then(function(result1, result2) {
    console.log('p1', result1); // rejestruje liczbę 7
    console.log('p2', result2); // rejestruje liczbę 11
    // może to zostać użyte do zapewnienia kodowi większego podobieństwa do specyfikacji A+
    var results = arguments;
});

// lub
var p1 = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(7);
    }, 2000);
});

var p2 = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(11);
    }, 3000);
});

Promise.all([p1, p2]).then(function(results) {
    console.log('p1', results[0]); // rejestruje liczbę 7
    console.log('p2', results[1]); // rejestruje liczbę 11
});




//****************************
//***** NIESPÓJNOŚCI ******
//****************************
var d = $.Deferred();
d.reject(new Error('Coś się stało!'));
var p = d.promise();

p.then(null, function(x) {
    console.log(x);
    return $.Deferred().resolve(5).promise();
}).then(function(x){
    console.log('Przywrócono', x);// wyświetla: Przywrócono 5
});

p.then(null, function(x) {
    console.log(x);
    return 5;// brak przywracania, zmieniana jest jedynie wartość
}).then(null, function(x){
    console.log('Nie przywrócono', x);// wyświetla: Nie przywrócono 5
});

// Niepowodzenie powoduje, że nie jest zwracany nowy obiekt Promise, dlatego nie ma miejsca przywracanie
p.fail(function(x) {
    console.log(x);
    return $.Deferred().resolve(5).promise();
    // zwraca 5;
}).then(null, function(x){
    console.log('Nie przywrócono', x);// wyświetla: Nie przywrócono Error...
});



// lub
var p = new Promise(function(resolve, reject) {
    reject(new Error('Coś się stało!'));
});
p.then(null, function(x) {
    console.log(x);
}).then(function(){
    console.log('Przywrócono');
});

p.catch(function(x) {
    console.log(x);
}).then(function(){
    console.log('Przywrócono');
});



//****************************
var p = $.Deferred(function (deferred) {
    throw new Error('Coś się stało!'); // w tym miejscu kończone jest wykonywanie
}).promise().then(null, function(x) {
    console.log(x); // nic nie jest wyświetlane
});

// albo
new Promise(function() {
    throw new Error('Coś się stało!');
}).then(null, function(x) {
    console.log(x);
});



//****************************
$.Deferred().resolve().promise().then(function() {
    throw new Error('Coś się stało!'); // w tym miejscu kończone jest wykonywanie
}).then(null, function(x) {
    console.log(x); // nic nie jest wyświetlane
});

$.Deferred().resolve().promise().then(function() {
    try { // to jest rozwiązanie
        throw new Error('Coś się stało!');
    } catch (e) {
        return $.Deferred().reject(e).promise();
    }
}).then(function(){
    console.log('Powodzenie'); // nic nie jest wyświetlane
}).then(null, function(x) { // prawie równoznaczne .fail()
    console.log(x); // logs 'Coś się stało!''
});

Promise.resolve().then(function() {
    throw new Error('Coś się stało!');
}).then(function(){
    console.log('Powodzenie'); // nic nie jest wyświetlane
}).then(null, function(x) { // równoznaczne .catch()
    console.log(x); // logs 'Coś się stało!''
});
