// change a default option value for a page by using:
// $.fn.vibrate.defaultOptions.loops = 12

(function($) {
	$.fn.vibrate = function(options) {
		var opts = $.extend({}, $.fn.vibrate.defaultOptions, options);

		this.each(function(i, element) {
			var $element = $(element);
			if ($element.css('position') === 'static') {
				$element.css({ position: 'relative' });
			}
		});

		for (var i = 0, len = opts.loops * 4; i < len; i++) {
			var animationProperties = {};
			var movement = (i % 2) ?
				'+=':
				'-=';

			movement += (i === 0 || i === len - 1) ?
				opts.amplitude / 2:
				opts.amplitude;

			var t = (i === 0 || i === len - 1) ?
				opts.period / 4:
				opts.period / 2;

			animationProperties[opts.direction] = movement;
			this.animate(animationProperties, t);
		}

		return this;
	};

	$.fn.vibrate.defaultOptions = {
		loops: 2,
		amplitude: 8,
		period: 100,
		direction: 'left'
	};
})(jQuery);
