(function() {
    'use strict';

    dashboard.informationBox = dashboard.informationBox || {};

    var $boxContainer = null;

    dashboard.informationBox.init = function() {
        $boxContainer = dashboard.$container.find('.boxContainer');

        $boxContainer.on('click', '.boxCloseButton', function() {
            var $button = $(this);
            dashboard.informationBox.close($button);
        });
    };

    dashboard.informationBox.openNew = function(itemName) {
        var boxHtml = '<div class="boxsizer"><article class="box">' +
                '<header class="boxHeader">' +
                    itemName +
                    '<button class="boxCloseButton">&#10006;</button>'+
                '</header>' +
                'Pole informacyjne dotyczące: ' + itemName +
            '</article></div>';
        $boxContainer.append(boxHtml);
    };

    dashboard.informationBox.close = function($boxElement) {
        $boxElement.closest('.boxsizer').remove();
    };

})();
