package main

import (
	"encoding/hex"
	"fmt"
	"os"

	"github.com/conformal/btcnet"
	"github.com/conformal/btcscript"
)

// go run extract-from-pk-script.go

// Ten przykład ilustruje pobieranie informacjie ze standardowego skryptu p2pkh

func main() {
	scriptHex := "76a914128004ff2fcaf13b2b91eb654b1dc2b674f7ec6188ac"

	ExtractPkScriptAddrs(scriptHex)
	// Dane wyjściowe:
	// Rodzaj skryptu: pubkeyhash
	// Adresy: [12gpXQVcCL2qhTNQgyLVdCFG2Qs2px98nV]
	// Wymagane podpisy: 1
}

func ExtractPkScriptAddrs(scriptHex string) {
	script, err := hex.DecodeString(scriptHex)
	handle(err)

	// Pobieranie i wyświetlanie informacji ze skryptu.
	scriptClass, addresses, reqSigs, err := btcscript.ExtractPkScriptAddrs(script, &btcnet.MainNetParams)
	handle(err)

	fmt.Println("Rodzaj skryptu:", scriptClass)
	fmt.Println("Adresy:", addresses)
	fmt.Println("Wymagane podpisy:", reqSigs)
}

func handle(err error) {
	if err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
