package main

import (
	"fmt"
	"os"

	"github.com/conformal/btcnet"
	"github.com/conformal/btcscript"
	"github.com/conformal/btcutil"
)

// Ten przykłąd ilustruje tworzenie skryptu wypłacającego środki na adres bitcoin.
// Kod wyświetla też utworzony skrypt (w formacie szesnastkowym) i przy użyciu funkcji
// DisasmString wyświetla skrypt po dezasemblacji.

func main() {
	addressStr := "12gpXQVcCL2qhTNQgyLVdCFG2Qs2px98nV"

	PayToAddrScript(addressStr)
	// Dane wyjściowe:
	// Skrypt szesnastkowo: 76a914128004ff2fcaf13b2b91eb654b1dc2b674f7ec6188ac
	// Skrypt po dezasemblacji: OP_DUP OP_HASH160 128004ff2fcaf13b2b91eb654b1dc2b674f7ec61 OP_EQUALVERIFY OP_CHECKSIG
}

func PayToAddrScript(addressStr string) {
	// Parsowanie docelowego adresu na format btcutil.Address, co jest
	// przydatne do zapewnienia poprawności adresu i ustalania jego rodzaju.
	// Jest to też konieczne w dalszym wywołaniu PayToAddrScript.
	address, err := btcutil.DecodeAddress(addressStr, &btcnet.MainNetParams)
	handle(err)

	// Tworzenie skryptu przekazującego środki na dany adres.
	script, err := btcscript.PayToAddrScript(address)
	handle(err)
	fmt.Printf("Skrypt szesnastkowo: %x\n", script)

	disasm, err := btcscript.DisasmString(script)
	handle(err)
	fmt.Println("Skrypt po dezasemblacji:", disasm)
}

func handle(err error) {
	if err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
