import bitcoin

# Generowanie losowego klucza prywatnego
valid_private_key = False
while not valid_private_key:
    private_key = bitcoin.random_key()
    decoded_private_key = bitcoin.decode_privkey(private_key, 'hex')
    valid_private_key =  0 < decoded_private_key < bitcoin.N

print "Klucz prywatny (szesnastkowo) to: ", private_key
print "Klucz prywatny (dziesiętnie) to: ", decoded_private_key

# Przekształcanie klucza prywatnego na format WIF
wif_encoded_private_key = bitcoin.encode_privkey(decoded_private_key, 'wif')
print "Klucz prywatny (w formacie WIF) to: ", wif_encoded_private_key

# Dodawanie przyrostka "01" oznaczającego skompresowany klucz prywatny
compressed_private_key = private_key + '01'
print "Skompresowany klucz prywatny (szesnastkowo) to: ", compressed_private_key

# Generowanie danych w formacie WIF na podstawie skompresowanego klucza prywatnego (skompresowany WIF)
wif_compressed_private_key = bitcoin.encode_privkey(
    bitcoin.decode_privkey(compressed_private_key, 'hex'), 'wif')
print "Klucz prywatny (skompresowany WIF) to: ", wif_compressed_private_key

# Mnożenie generatora G przez klucz prywatny w celu uzyskania punktu reprezentującego klucz publiczny
public_key = bitcoin.fast_multiply(bitcoin.G, decoded_private_key)
print "Współrzędne (x,y) klucza publicznego to:", public_key

# Kodowanie w formacie szesnastkowym (z przedrostkiem 04)
hex_encoded_public_key = bitcoin.encode_pubkey(public_key,'hex')
print "Klucz publiczny w formacie szesnastkowym:", hex_encoded_public_key

# Kompresowanie klucza publicznego. Przedrostek jest zmieniany na zgodnie z tym, czy y jest parzyste czy nieparzyste
(public_key_x, public_key_y) = public_key
if (public_key_y % 2) == 0:
    compressed_prefix = '02'
else:
    compressed_prefix = '03'
hex_compressed_public_key = compressed_prefix + bitcoin.encode(public_key_x, 16)
print "Skompresowany klucz publiczny (szesnastkowo):", hex_compressed_public_key

# Generowanie adresu bitcoin na podstawie klucza publicznego
print "Adres bitcoin w formacie base58check:", bitcoin.pubkey_to_address(public_key)

# Generowanie skompresowanego adresu bitcoin na podstawie skompresowanego klucza publicznego
print "Skompresowany adres bitcoin w formacie base58check:", \
    bitcoin.pubkey_to_address(hex_compressed_public_key)

