#!/usr/bin/env python
# Przykładowy algorytm Proof-of-Work

import hashlib
import time

max_nonce = 2 ** 32 # 4 miliardy

def proof_of_work(header, difficulty_bits):
    
    # Obliczanie celu
    target = 2 ** (256-difficulty_bits)
    
    for nonce in xrange(max_nonce):
        hash_result = hashlib.sha256(str(header)+str(nonce)).hexdigest()
        
        # Sprawdzanie, czy wynik jest prawidłowy (mniejszy od celu)
        if long(hash_result, 16) < target:
            print "Powodzenie dla wartości nonce %d" % nonce
            print "Skrót to %s" % hash_result
            return (hash_result,nonce)
            
    print "Niepowodzenie po %d (max_nonce) próbach" % nonce
    return nonce

    
if __name__ == '__main__':
    
    nonce = 0
    hash_result = ''
     
    # Poziom trudności 0 do 31 bitów  
    for difficulty_bits in xrange(32):
        
        difficulty = 2 ** difficulty_bits
        print "Poziom trudności: %ld (liczba bitów = %d)" % (difficulty, difficulty_bits)
    
        print "Rozpoczynanie wyszukiwania..."
        
        # Zapisywanie aktualnego czasu
        start_time = time.time()
        
        # Tworzenie nowego bloku obejmującego skrót z poprzedniego bloku.
        # Fikcyjny blok transakcji (zwykły łańcuch znaków)
        new_block = 'test block with transactions' + hash_result 
        
        # Znajdowanie prawidłowej wartości nonce dla nowego bloku
        (hash_result, nonce) = proof_of_work(new_block, difficulty_bits) 
        
        # Zapisywanie czasu zakończenia pracy
        end_time = time.time()
        
        elapsed_time = end_time - start_time
        print "Czas pracy: %.4f (w sekundach)" % elapsed_time
    
        if elapsed_time > 0:
            
            # Szacowanie liczby skrótów na sekundę
            hash_power = float(long(nonce)/elapsed_time)
            print "Moc obliczeniowa: %ld (w skrótach na sekundę)" % hash_power