# Pobieranie niewydanych wyjść z API serwisu blockchain

import json
import requests

# Przykładowy adres
address = '1Dorian4RoXcnBv9hnQ4Y2C1an6NJ4UrjX'

# Adres URL interfejsu API to: https://blockchain.info/unspent?active=<address>
# Zwracany jest obiekt w formacie JSON z listą "unspent_outputs" obejmującą UTXO:
#{	"unspent_outputs":[
#   {
#     "tx_hash":"ebadfaa92f1fd29e2fe296eda702c48bd11ffd52313e986e99ddad9084062167",
#     "tx_index":51919767,
#     "tx_output_n": 1,
#     "script":"76a9148c7e252f8d64b0b6e313985915110fcfefcf4a2d88ac",
#     "value": 8000000,
#     "value_hex": "7a1200",
#     "confirmations":28691
#   },
# ...
#]}

resp = requests.get('https://blockchain.info/unspent?active=%s' % address)
utxo_set = json.loads(resp.text)["unspent_outputs"]

for utxo in utxo_set:
    print "%s:%d - %ld (w Satoshi)" % (utxo['tx_hash'], utxo['tx_output_n'], utxo['value'])
