package com.example.administrator.kopiasms;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.database.Cursor;
import android.util.Log;
import android.net.Uri;
import java.util.ArrayList;
import android.os.Environment;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        backupSMS();
    }

    public ArrayList<String> smsBuffer = new ArrayList<String>();
    String smsFile = "SMS"+".csv";
    private void backupSMS() {
        smsBuffer.clear();
        Uri mSmsinboxQueryUri = Uri.parse("content://sms");
        Cursor cursor1 = getContentResolver().query(mSmsinboxQueryUri,
                new String[] {"_id", "thread_id", "address", "person", "date", "body", "type" },
                              null, null, null);
        String[] columns = new String[] {"_id", "thread_id", "address",
                                         "person", "date", "body", "type"};
        if (cursor1.getCount() > 0) {
            String count = Integer.toString(cursor1.getCount());
            Log.d("Liczba: ", count);
            while (cursor1.moveToNext()) {
                String messageId = cursor1.getString(cursor1.getColumnIndex(columns[0]));
                String threadId = cursor1.getString(cursor1.getColumnIndex(columns[1]));
                String address = cursor1.getString(cursor1.getColumnIndex(columns[2]));
                String name = cursor1.getString(cursor1.getColumnIndex(columns[3]));
                String date = cursor1.getString(cursor1.getColumnIndex(columns[4]));
                String msg = cursor1.getString(cursor1.getColumnIndex(columns[5]));
                String type = cursor1.getString(cursor1.getColumnIndex(columns[6]));
                smsBuffer.add(messageId + "," + threadId + "," + address + "," + name +
                        "," + date + "," + msg + "," + type);
            }
            generateCSVFileForSMS(smsBuffer);
        }
    }
    private void generateCSVFileForSMS(ArrayList<String>list) {
        try {
            String storage_path = Environment.getExternalStorageDirectory().toString() +
                    File.separator + smsFile;
            System.out.println("Udało się!");
            FileWriter write = new FileWriter(storage_path);
            write.append("ID komunikatu,ID wątku,adres,nazwisko,data,treść,typ");
            write.append('\n');
            for (String s : list) {
                write.append(s);
                write.append('\n');
            }
            write.flush();
            write.close();
        }
        catch (NullPointerException e) {
            System.out.println("Wyjątek, zerowy wskaźnik "+e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}
