#!usr/bin/env python3
from PyPDF2 import PdfFileReader, PdfFileWriter
import os, time, os.path, stat
from PyPDF2.generic import NameObject, createStringObject

def get_metadata():
    for dirpath, dirnames, files in os.walk("pdf"):
        for data in files:
            ext = data.lower().rsplit('.', 1)[-1]
            if ext in ['pdf']:
                print("[--- Plik:", dirpath + os.path.sep + data)
                print("------------------------------------------")
                pdfReader = PdfFileReader(open(dirpath + os.path.sep + data, 'rb'))
                info = pdfReader.getDocumentInfo()
                for metaItem in info:
                    print ('[+] ' + metaItem.strip( '/' ) + ': ' + info[metaItem])
                pages = pdfReader.getNumPages()
                print ('[+] Liczba stron:', pages)
                layout = pdfReader.getPageLayout()
                print ('[+] Układ: ' + str(layout))
                xmpinfo = pdfReader.getXmpMetadata()
                if hasattr(xmpinfo, 'dc_contributor'): print ('[+] Współautor:' , xmpinfo.dc_contributor)
                if hasattr(xmpinfo, 'dc_identifier'): print ( '[+] Identyfikator:', xmpinfo.dc_identifier)
                if hasattr(xmpinfo, 'dc_date'): print ('[+] Data:', xmpinfo.dc_date)
                if hasattr(xmpinfo, 'dc_source'): print ('[+] Źródło:', xmpinfo.dc_source)
                if hasattr(xmpinfo, 'dc_subject'): print ('[+] Temat:' , xmpinfo.dc_subject)
                if hasattr(xmpinfo, 'xmp_modifyDate'): print ('[+] Data modyfikacji:', xmpinfo.xmp_modifyDate)
                if hasattr(xmpinfo, 'xmp_metadataDate'): print ('[+] Data metadanych:', xmpinfo.xmp_metadataDate)
                if hasattr(xmpinfo, 'xmpmm_documentId'): print ('[+] Ident. dokumentu:' , xmpinfo.xmpmm_documentId)
                if hasattr(xmpinfo, 'xmpmm_instanceId'): print ('[+] Ident. instancji:', xmpinfo.xmpmm_instanceId)
                if hasattr(xmpinfo, 'pdf_keywords'): print ('[+] Słowa kluczowe:', xmpinfo.pdf_keywords)
                if hasattr(xmpinfo, 'pdf_pdfversion'): print ('[+] Wersja PDF:', xmpinfo.pdf_pdfversion)
                if hasattr(xmpinfo,'dc_publisher'):
                    for published in xmpinfo.dc_publisher:
                        if publisher:
                            print ("[+] Wydawca:\t" + publisher) 
            fsize = os.stat((dirpath+os.path.sep+data))
            print ('[+] Wielkość:', fsize[6], 'B\n\n')

if __name__ == "__main__":
    get_metadata()