#!/usr/bin/python3
from Registry import Registry
import sys

def getCurrentControlSet(registry):
    try:
        key = registry.open("Select")
        for value in key.values():
            if value.name() == "Current":
                return value.value()
    except Registry.RegistryKeyNotFoundException as exception:
        print("Brak klucza SYSTEM / Select", exception)

def getServiceInfo(dictionary):
    serviceType = { 1 : "Sterownik urządzenia", 2 : "Sterownik systemu plików", 4 : "Argumenty adaptera",
    8 : "Interpreter sterownika systemu plików", 16 : "Proces", 32 : "Współdzielony proces", 272 : "Niezależny interaktywny program",
    288 : "Współdzielony interaktywny program" }
    print(" Nazwa usługi: %s" % dictionary["SERVICE_NAME"])
    if "DisplayName" in dictionary:
        print (" Nazwa wyświetlana: %s" % "".join(dictionary["DisplayName"]).encode('utf8'))
    if "ImagePath" in dictionary:
        print(" Ścieżka obrazu: %s" % dictionary["ImagePath"])
    if "Type" in dictionary:
        print(" Typ: %s" % serviceType[dictionary["Type"]])
    if "Group" in dictionary:
        print(" Grupa: %s" % dictionary["Group"])
    print("--------------------------")

def serviceParams(subkey):
    service = {}
    service["SERVICE_NAME"] = subkey.name()
    service["ModifiedTime"] = subkey.timestamp()
    for value in subkey.values():
        service[value.name()] = value.value()
    getServiceInfo(service)

def servicesKey(registry, controlset):
    serviceskey = "ControlSet00%d\\Services" % controlset
    try:
        key = registry.open(serviceskey)
    except Registry.RegistryKeyNotFoundException as exception:
        print("Brak klucza Services", exception)
    for subkey in key.subkeys():
        serviceParams(subkey)

if __name__ == "__main__" :
    registry = Registry.Registry(sys.argv[1])
    controlset = getCurrentControlSet(registry)
    servicesKey(registry, controlset)