from Crypto.Cipher import AES
from Crypto.Protocol.KDF import PBKDF2
from Crypto import Random

# Klucz musi mieć długość 16, 24 lub 32 bajty.
key = "poufny-klucz-123"
iterations = 10000
key_size = 16
salt = Random.new().read(key_size)
iv = Random.new().read(AES.block_size)
derived_key = PBKDF2(key, salt, key_size, iterations)
encrypt_AES = AES.new(derived_key, AES.MODE_CBC, iv)
# Dane dopełnione do 32 bajtów.
message = "To jest poufny komunikat        ".encode("utf8")
ciphertext = encrypt_AES.encrypt(message)
print("Zaszyfrowany tekst:", ciphertext)
decrypt_AES = AES.new(derived_key, AES.MODE_CBC, iv)
message_decrypted = decrypt_AES.decrypt(ciphertext)
print("Odszyfrowany tekst:", message_decrypted.strip().decode())