#!/usr/bin/env python3
import socket
import geoip2.database
import argparse

parser = argparse.ArgumentParser(description = 'Geolokalizacja adresu IP')
parser.add_argument('--hostname', action = "store", dest = "hostname", default = 'python.org')
given_args = parser.parse_args()
hostname = given_args.hostname
ip_address = socket.gethostbyname(hostname)
print("Adres IP: {0}".format(ip_address))
reader = geoip2.database.Reader('GeoLite2-City.mmdb')
response = reader.city(ip_address)
if response is not None:
    print('Kraj: ', response.country)
    print('Kontynent: ', response.continent)
    print('Lokalizacja: ', response.location)