#!/usr/bin/env python

import socket
import sys
from datetime import datetime
import errno

remoteServer = input("Podaj adres komputera do przeskanowania: ")
remoteServerIP = socket.gethostbyname(remoteServer)

print("Podaj zakres portów do przeskanowania:")
startPort = input("Port początkowy: ")
endPort = input("Port końcowy: ")

print("Czekaj, trwa skanowanie hosta", remoteServerIP)

time_init = datetime.now()

try:
    for port in range(int(startPort), int(endPort)):
        print ("Sprawdzanie portu {} ...".format(port))
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.settimeout(5)
        result = sock.connect_ex((remoteServerIP, port))
        if result == 0:
            print("Port {} otwarty".format(port))
        else:
            print("Port {} zamknięty".format(port))
            print("Powód:", errno.errorcode[result])
        sock.close()

except KeyboardInterrupt:
    print("Nacisnąłeś Ctrl+C")
    sys.exit()
except socket.gaierror:
    print("Problem z odwzorowaniem nazwy hosta. Wyjście.")
    sys.exit()
except socket.error:
    print("Błąd połączenia")
    sys.exit()

time_finish = datetime.now()
total = time_finish - time_init
print("Czas skanowania:", total)