import dns.resolver

def main(domain):
    records = ['A', 'AAAA', 'NS', 'SOA', 'MX', 'TXT']
    for record in records:
        try:
            responses = dns.resolver.query(domain, record)
            print("\nZawartość rekordu", record)
            print("-----------------------------------")
            for response in responses:
                print(response)
        except Exception as exception:
            print("Błąd rekordu", record)
            print("Wyjątek:", exception)

if __name__ == '__main__':
    try:
        main('helion.pl')
    except KeyboardInterrupt:
        exit()