#!usr/bin/env python3
import sqlite3
import datetime
import optparse

def fixDate(timestamp):
    # Przeglądarka Chrome zapisuje czas jako liczbę mikrosekund, jakie upłynęły
    # od 1 stycznia 1601 r. Aby zmienić format tworzymy najpierw obiekt
    # reprezentujący powyższą datę:
    epoch_start = datetime.datetime(1601, 1, 1)
    # Następnie tworzymy obiekt zawierający liczbę mikrosekund odpowiadającą
    # znacznikowi czasu:
    delta = datetime.timedelta(microseconds = int(timestamp))
    # Na koniec zwracamy sumę obu obiektów:
    return epoch_start + delta

def getMetadataHistoryFile(locationHistoryFile):
    sql_connect = sqlite3.connect(locationHistoryFile)
    for row in sql_connect.execute('SELECT target_path, referrer, start_time, end_time, received_bytes FROM downloads;'):
        print ("Plik:", row[0].encode('utf-8'))
        print ("\tStrona:", str(row[1]))
        print ("\tPoczątek:", str(fixDate(row[2])))
        print ("\tKoniec:", str(fixDate(row[3])))
        print ("\tWielkość:", str(row[4]))

def main():
    parser = optparse.OptionParser('--location <nazwa pliku>')
    parser.add_option('--location', dest = 'location', type = 'string', help = 'nazwa pliku')
    (options, args) = parser.parse_args()
    location = options.location
    getMetadataHistoryFile(location)

if __name__ == '__main__':
    main()