import shodan
import requests
import os

SHODAN_API_KEY = os.environ['SHODAN_API_KEY'] 
api = shodan.Shodan(SHODAN_API_KEY)
domain = 'helion.pl'
dnsResolve = f"https://api.shodan.io/dns/resolve?hostnames={domain}&key={SHODAN_API_KEY}"

try:
    resolved = requests.get(dnsResolve)
    hostIP = resolved.json()[domain]
        host = api.host(hostIP)
    print("IP: %s" % host['ip_str'])
    print("Organizacja: %s" % host.get('org', 'n/a'))
    print("System operacyjny: %s" % host.get('os', 'n/a'))
    for item in host['data']:
        print("Port: %s" % item['port'])
        print("Baner: %s" % item['data'])
except shodan.APIError as exception:
        print('Błąd: %s' % exception)