int checkClassHooked(char * class_name)
{
  char imagepath[512];
  int n;
  Dl_info info;
  
  id c = objc_lookUpClass(class_name);
  Method * m = class_copyMethodList(c, &n);
  
  for (int i=0; i<n; i++)
  {
    char * methodname = sel_getName(method_getName(m[i]));
    void * methodimp = (void *) method_getImplementation(m[i]);

    int d = dladdr((const void*) methodimp, &info);
    if (!d) return YES;

    memset(imagepath, 0x00, sizeof(imagepath));
    memcpy(imagepath, info.dli_fname, 9);
    if (strcmp(imagepath, "/usr/lib/") == 0) continue;

    memset(imagepath, 0x00, sizeof(imagepath));
    memcpy(imagepath, info.dli_fname, 27);
    if (strcmp(imagepath, "/System/Library/Frameworks/") == 0) continue;

    memset(imagepath, 0x00, sizeof(imagepath));
    memcpy(imagepath, info.dli_fname, 34);
    if (strcmp(imagepath, "/System/Library/PrivateFrameworks/") == 0) continue;

    memset(imagepath, 0x00, sizeof(imagepath));
    memcpy(imagepath, info.dli_fname, 29);
    if (strcmp(imagepath, "/System/Library/Accessibility") == 0) continue;

    memset(imagepath, 0x00, sizeof(imagepath));
    memcpy(imagepath, info.dli_fname, 25);
    if (strcmp(imagepath, "/System/Library/TextInput") == 0) continue;

    // check image name against the apps image location
    if (strcmp(info.dli_fname, image_name) == 0) continue;
    return YES;
  }
  return NO;
}