from burp import IBurpExtender, IHttpListener

class BurpExtender(IBurpExtender, IHttpListener):
    def registerExtenderCallbacks(self, callbacks):
        # Make callbacks available to whole class
        self._callbacks = callbacks
        # Make helpers available to whole class
        self._helpers = callbacks.getHelpers()
        # Set name
        callbacks.setExtensionName("Inject JavaScript Alert")
        # Register HTTP listener
        callbacks.registerHttpListener(self)
        return
    
    def processHttpMessage(self, toolFlag, messageIsRequest, messageInfo):
        # Only process responses
        if not messageIsRequest:
            # Get response
            response = messageInfo.getResponse()
            responseStr = self._callbacks.getHelpers()
                          .bytesToString(response)
            responseParsed = self._helpers.analyzeResponse(response)
            body = responseStr[responseParsed.getBodyOffset():]
            headers = responseParsed.getHeaders()
            
            # Inject <script> into <head>
            changedBody = body.replace("<head>", 
                          "<head><script>alert('w00t')</script>")
            changedBodyBytes = self._callbacks.getHelpers()
                               .stringToBytes(changedBody)
            httpResponse = self._callbacks.getHelpers()
                           .buildHttpMessage(headers, changedBodyBytes);

            # Set the response if the body changed and alert
            if body != changedBody:
                messageInfo.setResponse(httpResponse)
                self._callbacks.issueAlert("Injected JavaScript!")
